/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import com.sun.portal.portletcontainer.common.descriptor.SharedSessionAttributeDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentExtensionDescriptor {
    private static final String RENDER_URL_PARAMETER_CACHE_DISABLED = "render-url-parameter-cache-disabled";
    private static final String PORTAL_QUERY_PARAMETERS = "portal-query-parameters";
    private static final String SHARED_SESSION_ATTRIBUTE = "shared-session-attribute";
    private static final String NAME = "name";
    private Map<String, List<String>> portalQueryParameters = new HashMap<String, List<String>>();
    private List<String> renderURLParameterCacheDisabledList = new ArrayList<String>();
    private List<SharedSessionAttributeDescriptor> sharedSessionAttributeDescriptors;

    public void load(Element root, String namespaceURI) throws DeploymentDescriptorException {
        List<Element> portletElements = PortletXMLDocumentHelper.getChildElements(root, "portlet");
        for (Element portletElement : portletElements) {
            String renderURLParameterCacheDisabled;
            String portletName = PortletXMLDocumentHelper.getChildTextTrim(portletElement, "portlet-name");
            List<Element> portalQueryParameterNameElements = PortletXMLDocumentHelper.getChildElements(portletElement, PORTAL_QUERY_PARAMETERS);
            if (!portalQueryParameterNameElements.isEmpty()) {
                ArrayList<String> portalQueryParameterNames = new ArrayList<String>();
                for (Element nameElement : portalQueryParameterNameElements) {
                    String name = PortletXMLDocumentHelper.getChildTextTrim(nameElement, NAME);
                    portalQueryParameterNames.add(name);
                }
                this.portalQueryParameters.put(portletName, portalQueryParameterNames);
            }
            if ((renderURLParameterCacheDisabled = PortletXMLDocumentHelper.getChildTextTrim(portletElement, RENDER_URL_PARAMETER_CACHE_DISABLED)) == null || !renderURLParameterCacheDisabled.equals("true")) continue;
            this.renderURLParameterCacheDisabledList.add(portletName);
        }
        List<Element> sharedSessionAttributeElements = PortletXMLDocumentHelper.getChildElements(root, SHARED_SESSION_ATTRIBUTE);
        if (sharedSessionAttributeElements.size() > 0) {
            this.sharedSessionAttributeDescriptors = new ArrayList<SharedSessionAttributeDescriptor>(sharedSessionAttributeElements.size());
            for (Element sharedSessionAttributeElement : sharedSessionAttributeElements) {
                SharedSessionAttributeDescriptor sharedSessionAttributeDescriptor = new SharedSessionAttributeDescriptor();
                sharedSessionAttributeDescriptor.load(sharedSessionAttributeElement, namespaceURI);
                this.sharedSessionAttributeDescriptors.add(sharedSessionAttributeDescriptor);
            }
        }
    }

    public List<String> getPortalQueryParameters(String portletName) {
        return this.portalQueryParameters.get(portletName);
    }

    public boolean renderURLParameterCacheDisabled(String portletName) {
        boolean renderURLParameterCacheDisabled = false;
        if (this.renderURLParameterCacheDisabledList.contains(portletName)) {
            renderURLParameterCacheDisabled = true;
        }
        return renderURLParameterCacheDisabled;
    }

    public List<SharedSessionAttributeDescriptor> getSharedSessionAttributeDescriptors() {
        return this.sharedSessionAttributeDescriptors;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DeploymentExtensionDescriptor ");
        sb.append("[ render-url-parameter-cache-disabled: ");
        sb.append(this.renderURLParameterCacheDisabledList);
        sb.append(" ]");
        sb.append("\n");
        sb.append("[ portal-query-parameters:");
        sb.append(this.portalQueryParameters);
        sb.append(" ]");
        return sb.toString();
    }
}

