/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.appengine.LifecycleManager;
import com.sun.portal.portletcontainer.common.NoOpEntityResolver;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentExtensionDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContainerUtil {
    private static Logger logger = ContainerLogger.getLogger(PortletContainerUtil.class, (String)"PCCLogMessages");
    private static final String SUN_PORTLET_XML = "sun-portlet.xml";

    public static Map<String, String[]> getMergedParameterMap(Map<String, String[]> parameterMap1, Map<String, String[]> parameterMap2, boolean append) {
        Map<String, String[]> mergedParameterMap = null;
        if (parameterMap1 == null) {
            mergedParameterMap = parameterMap2;
        } else if (parameterMap2 == null) {
            mergedParameterMap = parameterMap1;
        } else {
            mergedParameterMap = new HashMap<String, String[]>();
            Set<Map.Entry<String, String[]>> entries1 = parameterMap1.entrySet();
            for (Map.Entry<String, String[]> mapEntry : entries1) {
                String key1 = mapEntry.getKey();
                String[] values1 = mapEntry.getValue();
                String[] values2 = parameterMap2.get(key1);
                if (append && values2 != null) {
                    ArrayList<String> list1 = new ArrayList<String>(Arrays.asList(values1));
                    ArrayList<String> list2 = new ArrayList<String>(Arrays.asList(values2));
                    list1.addAll(list2);
                    mergedParameterMap.put(key1, list1.toArray(new String[0]));
                    continue;
                }
                mergedParameterMap.put(key1, values1);
            }
            Set<Map.Entry<String, String[]>> entries2 = parameterMap2.entrySet();
            for (Map.Entry<String, String[]> mapEntry : entries2) {
                String key2 = mapEntry.getKey();
                if (parameterMap1.containsKey(key2)) continue;
                mergedParameterMap.put(key2, mapEntry.getValue());
            }
        }
        return mergedParameterMap;
    }

    public static ResourceBundle getResourceBundle(Map<String, Map<String, ResourceBundle>> portletResourceMap, String portletName, Locale locale) {
        Map<String, ResourceBundle> resBundleMap;
        ResourceBundle bundle = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String localeString = locale.toString();
        if (portletResourceMap != null && (resBundleMap = portletResourceMap.get(portletName)) != null) {
            Map.Entry<String, ResourceBundle> mapEntry;
            String key;
            Set<Map.Entry<String, ResourceBundle>> entries = resBundleMap.entrySet();
            Iterator<Map.Entry<String, ResourceBundle>> i$ = entries.iterator();
            while (i$.hasNext() && (!localeString.startsWith(key = (mapEntry = i$.next()).getKey()) || (bundle = mapEntry.getValue()) == null)) {
            }
        }
        if (bundle != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "PSPL_PCCCSPPCCD0031", new String[]{portletName, localeString});
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PSPL_PCCCSPPCCD0032", new Object[]{portletName, localeString});
        }
        return bundle;
    }

    public static DeploymentExtensionDescriptor getSunPortletDescriptor(ServletContext portletAppContext) {
        if (portletAppContext != null) {
            LifecycleManager lifecycleManager = (LifecycleManager)portletAppContext.getAttribute("lifecycle_manager");
            return PortletContainerUtil.getSunPortletDescriptor(lifecycleManager);
        }
        return null;
    }

    public static DeploymentExtensionDescriptor getSunPortletDescriptor(LifecycleManager lifecycleManager) {
        DeploymentExtensionDescriptor sunPortletDescriptor = null;
        if (lifecycleManager != null) {
            sunPortletDescriptor = (DeploymentExtensionDescriptor)lifecycleManager.getPortletExtensionDescriptor(SUN_PORTLET_XML);
        }
        return sunPortletDescriptor;
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setCoalescing(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new NoOpEntityResolver());
        return builder;
    }
}

