/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.util.pool;

import com.sun.portal.portletcontainer.appengine.util.pool.ObjectManager;
import com.sun.portal.portletcontainer.appengine.util.pool.PartitionObject;
import com.sun.portal.portletcontainer.appengine.util.pool.Pool;
import com.sun.portal.portletcontainer.appengine.util.pool.SimpleObjectPool;
import java.util.Random;

public class ParallelObjectPool
implements Pool {
    private int minSize;
    private int maxSize;
    private int partitions;
    private Pool[] pools;
    private boolean destroyed;
    private int[] partitionUse;
    private Random random;

    public ParallelObjectPool(ObjectManager objectManager, int minSize, int maxSize, boolean overflow, int partitions) {
        if (partitions < 1) {
            throw new IllegalArgumentException("ParallelObjectPool.<init>: partitions<1");
        }
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.partitions = partitions;
        this.pools = new Pool[partitions];
        int partitionMinSize = minSize / partitions;
        int partitionMaxSize = maxSize / partitions;
        int partitionMinRest = minSize % partitions;
        int partitionMaxRest = maxSize % partitions;
        int min = partitionMinSize + (partitionMinRest-- > 0 ? 1 : 0);
        int max = partitionMaxSize + (partitionMaxRest-- > 0 ? 1 : 0);
        for (int i = 0; i < partitions; ++i) {
            this.pools[i] = new SimpleObjectPool(objectManager, min, max, overflow);
            min = partitionMinSize + (partitionMinRest-- > 0 ? 1 : 0);
            max = partitionMaxSize + (partitionMaxRest-- > 0 ? 1 : 0);
        }
        this.partitionUse = new int[partitions];
        this.random = new Random();
    }

    private int calculatePartition() {
        return this.partitions == 1 ? 0 : Math.abs(this.random.nextInt()) % this.partitions;
    }

    public Object obtainObject(Object param) {
        if (this.destroyed) {
            throw new IllegalStateException();
        }
        int partition = this.calculatePartition();
        Pool pool = this.pools[partition];
        Object o = pool.obtainObject(param);
        if (o == null) {
            for (int i = 0; o == null && i < this.partitions; ++i) {
                if (i == partition || (o = (pool = this.pools[i]).obtainObject(param)) == null) continue;
                partition = i;
            }
        }
        if (o != null && o instanceof PartitionObject) {
            ((PartitionObject)o).setPartition(partition);
            int n = partition;
            this.partitionUse[n] = this.partitionUse[n] + 1;
        }
        return o;
    }

    public void releaseObject(Object o) {
        int partition = o instanceof PartitionObject ? ((PartitionObject)o).getPartition() : this.calculatePartition();
        this.pools[partition].releaseObject(o);
    }

    public int getLeased() {
        int leased = 0;
        for (int i = 0; i < this.pools.length; ++i) {
            leased += this.pools[i].getLeased();
        }
        return leased;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int[] getPartitionUse() {
        return (int[])this.partitionUse.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxSize) {
        ParallelObjectPool parallelObjectPool = this;
        synchronized (parallelObjectPool) {
            if (this.destroyed) {
                throw new IllegalStateException();
            }
            int partitionMaxSize = maxSize / this.partitions;
            int partitionMaxRest = maxSize % this.partitions;
            int max = partitionMaxSize + (partitionMaxRest-- > 0 ? 1 : 0);
            for (int i = 0; i < this.partitions; ++i) {
                this.pools[i].setMaxSize(max);
                max = partitionMaxSize + (partitionMaxRest-- > 0 ? 1 : 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ParallelObjectPool parallelObjectPool = this;
        synchronized (parallelObjectPool) {
            if (this.destroyed) {
                throw new IllegalStateException();
            }
            this.destroyed = true;
            for (int i = 0; i < this.partitions; ++i) {
                this.pools[i].destroy();
            }
        }
    }

    public final boolean doesReuseObjects() {
        return true;
    }

    protected void finalize() {
        if (!this.destroyed) {
            this.destroy();
        }
    }
}

