/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.calendar.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.calendar.model.Classification;
import com.stratelia.webactiv.calendar.model.Priority;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class Schedulable
implements Serializable {
    private String id = null;
    private String name = null;
    private String delegatorId = null;
    private String description = null;
    private Classification classification = null;
    private String startDate = null;
    private String startHour = null;
    private String endDate = null;
    private String endHour = null;
    private Priority priority = null;
    private String externalId = null;
    protected static final SimpleDateFormat completeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    protected static final SimpleDateFormat hourFormat = new SimpleDateFormat("HH:mm");

    public Schedulable() {
    }

    public Schedulable(String name, String delegatorId) {
        this.setName(name);
        this.setDelegatorId(delegatorId);
    }

    public Schedulable(String id, String name, String delegatorId) {
        this(name, delegatorId);
        this.id = id;
    }

    public abstract Schedulable getCopy();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (name != null && name.length() == 0) {
            this.name = null;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id != null && id.length() == 0) {
            this.id = null;
        }
        this.id = id;
    }

    public void setDelegatorId(String delegatorId) {
        this.delegatorId = delegatorId;
        if (delegatorId != null && delegatorId.length() == 0) {
            this.delegatorId = null;
        }
    }

    public String getDelegatorId() {
        return this.delegatorId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Classification getClassification() {
        if (this.classification == null) {
            this.classification = new Classification();
        }
        return this.classification;
    }

    public Priority getPriority() {
        if (this.priority == null) {
            this.priority = new Priority();
        }
        return this.priority;
    }

    public void setStartDay(String date) throws ParseException {
        if (date == null) {
            this.startDate = null;
            return;
        }
        if (date.length() == 0) {
            this.startDate = null;
            return;
        }
        dateFormat.parse(date);
        this.startDate = date;
    }

    public void setStartHour(String hour) throws ParseException {
        if (hour == null) {
            this.startHour = null;
            return;
        }
        if (hour.length() == 0) {
            this.startHour = null;
            return;
        }
        hourFormat.parse(hour);
        this.startHour = hour;
    }

    public String getStartDay() {
        return this.startDate;
    }

    public Date getStartDate() {
        if (this.getStartDay() == null) {
            return null;
        }
        try {
            if (this.getStartHour() == null) {
                return dateFormat.parse(this.getStartDay());
            }
            return completeFormat.parse(this.getStartDay() + " " + this.getStartHour());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setStartDate(Date start) {
        if (start == null) {
            this.startDate = null;
            return;
        }
        try {
            this.setStartDay(dateFormat.format(start));
        }
        catch (ParseException e) {
            SilverTrace.warn((String)"calendar", (String)"Schedulable.setStartDate(setStartDate(java.util.Date start)", (String)"calendar_MSG_NOT_PARSE_DATE");
        }
    }

    public String getStartHour() {
        return this.startHour;
    }

    public void setEndDay(String date) throws ParseException {
        if (date == null) {
            this.endDate = null;
            return;
        }
        if (date.length() == 0) {
            this.endDate = null;
            return;
        }
        dateFormat.parse(date);
        this.endDate = date;
    }

    public void setEndHour(String hour) throws ParseException {
        if (hour == null) {
            this.endHour = null;
            return;
        }
        if (hour.length() == 0) {
            this.endHour = null;
            return;
        }
        hourFormat.parse(hour);
        this.endHour = hour;
    }

    public String getEndDay() {
        return this.endDate;
    }

    public String getEndHour() {
        return this.endHour;
    }

    public Date getEndDate() {
        if (this.getEndDay() == null) {
            return null;
        }
        try {
            if (this.getEndHour() != null) {
                return completeFormat.parse(this.getEndDay() + " " + this.getEndHour());
            }
            return dateFormat.parse(this.getEndDay());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setEndDate(Date end) {
        if (end == null) {
            this.endDate = null;
            return;
        }
        try {
            this.setEndDay(dateFormat.format(end));
        }
        catch (ParseException e) {
            SilverTrace.warn((String)"calendar", (String)"Schedulable.setStartDate(setStartDate(java.util.Date start)", (String)"calendar_MSG_NOT_PARSE_DATE");
        }
    }

    public String getStringDuration() {
        try {
            Date startDate = completeFormat.parse(this.getStartDay() + " " + this.getStartHour());
            Date endDate = completeFormat.parse(this.getEndDay() + " " + this.getEndHour());
            long ms = endDate.getTime() - startDate.getTime();
            return Schedulable.hourMinuteToString((int)(ms / 60000L % 60L), (int)(ms / 3600000L));
        }
        catch (Exception e) {
            SilverTrace.warn((String)"calendar", (String)"Schedulable.getStringDuration", (String)"calendar_MSG_NOT_SCEDULE", (String)"return = 00:00");
            return "00:00";
        }
    }

    public int getMinuteDuration() {
        try {
            Date startDate = completeFormat.parse(this.getStartDay() + " " + this.getStartHour());
            Date endDate = completeFormat.parse(this.getEndDay() + " " + this.getEndHour());
            long ms = endDate.getTime() - startDate.getTime();
            return (int)(ms / 60000L);
        }
        catch (Exception e) {
            SilverTrace.warn((String)"calendar", (String)"Schedulable.getMinuteDuration() ", (String)"calendar_MSG_NOT_SCEDULE", (String)"return = 0");
            return 0;
        }
    }

    public boolean isOver(Schedulable schedule) {
        if (this.getStartHour() == null || this.getEndHour() == null) {
            return false;
        }
        if (schedule.getStartHour() == null || schedule.getEndHour() == null) {
            return false;
        }
        if (this.getStartDate().compareTo(schedule.getStartDate()) <= 0 && this.getEndDate().compareTo(schedule.getStartDate()) > 0) {
            return true;
        }
        if (this.getStartDate().compareTo(schedule.getEndDate()) < 0 && this.getEndDate().compareTo(schedule.getEndDate()) >= 0) {
            return true;
        }
        if (schedule.getStartDate().compareTo(this.getStartDate()) <= 0 && schedule.getEndDate().compareTo(this.getStartDate()) > 0) {
            return true;
        }
        return schedule.getStartDate().compareTo(this.getEndDate()) < 0 && schedule.getEndDate().compareTo(this.getEndDate()) >= 0;
    }

    public String toString() {
        String result = " id = " + this.getId() + " name = " + this.getName() + " delegatorId = " + this.getDelegatorId() + " description = " + this.getDescription() + " startDay = " + this.getStartDay() + " startHour = " + this.getStartHour() + " endDay = " + this.getEndDay() + " endHour = " + this.getEndHour() + " externalId = " + this.getExternalId();
        return result;
    }

    public static String hourMinuteToString(int hour, int minute) {
        String m;
        String h = String.valueOf(hour);
        if (h.length() < 2) {
            h = "0" + h;
        }
        if ((m = String.valueOf(minute)).length() < 2) {
            m = "0" + m;
        }
        return h + ":" + m;
    }

    public static String quaterCountToHourString(int quaterCount) {
        String minute;
        String hour = String.valueOf(quaterCount >> 2);
        if (hour.length() < 2) {
            hour = "0" + hour;
        }
        if ((minute = String.valueOf((quaterCount & 3) * 15)).length() < 2) {
            minute = "0" + minute;
        }
        return hour + ":" + minute;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String outlookId) {
        this.externalId = outlookId;
    }
}

