/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mylinks.model;

import java.io.Serializable;
import java.util.Collection;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.mylinks.model.CategoryDetail;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.kernel.util.StringUtil;

public class LinkDetail
implements Serializable,
Securable {
    private static final long serialVersionUID = 1841282101128766762L;
    private int linkId;
    private int position;
    private boolean hasPosition;
    private String name;
    private String description;
    private String url;
    private boolean visible;
    private boolean popup;
    private String userId;
    private String instanceId;
    private String objectId;
    private CategoryDetail category;

    public LinkDetail() {
    }

    public LinkDetail(String name, String description, String url, boolean visible, boolean popup) {
        this.name = name;
        this.description = description;
        this.url = url;
        this.visible = visible;
        this.popup = popup;
    }

    public LinkDetail(LinkDetail other) {
        this.linkId = other.linkId;
        this.position = other.position;
        this.hasPosition = other.hasPosition;
        this.name = other.name;
        this.description = other.description;
        this.url = other.url;
        this.visible = other.visible;
        this.popup = other.popup;
        this.userId = other.userId;
        this.instanceId = other.instanceId;
        this.objectId = other.objectId;
        this.category = other.category != null ? new CategoryDetail(other.category) : null;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public int getLinkId() {
        return this.linkId;
    }

    public void setLinkId(int linkId) {
        this.linkId = linkId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isPopup() {
        return this.popup;
    }

    public void setPopup(boolean popup) {
        this.popup = popup;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean hasPosition() {
        return this.hasPosition;
    }

    public void setHasPosition(boolean hasPosition) {
        this.hasPosition = hasPosition;
    }

    public CategoryDetail getCategory() {
        return this.category;
    }

    public void setCategory(CategoryDetail category) {
        this.category = category;
    }

    public boolean canBeAccessedBy(User user) {
        SilverpeasComponentInstance componentInstance;
        boolean canBeAccessed = StringUtil.isDefined((String)this.instanceId) ? (componentInstance = (SilverpeasComponentInstance)SilverpeasComponentInstance.getById((String)this.instanceId).orElse(null)) != null && (componentInstance.isPublic() || componentInstance.isPersonal() || ComponentAccessControl.get().isUserAuthorized(user.getId(), (Object)this.instanceId)) : true;
        return canBeAccessed;
    }

    public boolean canBeModifiedBy(User user) {
        boolean canBeModified;
        if (StringUtil.isDefined((String)this.instanceId)) {
            Collection roles = OrganizationController.get().getUserSilverpeasRolesOn(User.getCurrentRequester(), this.instanceId);
            canBeModified = roles.contains(SilverpeasRole.ADMIN);
        } else {
            canBeModified = user.getId().equals(this.userId);
        }
        return canBeModified;
    }
}

