/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ear.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ear.parser.spec.Attribute;
import org.jboss.metadata.ear.parser.spec.EarModuleMetaDataParser;
import org.jboss.metadata.ear.parser.spec.Element;
import org.jboss.metadata.ear.spec.EarEnvironmentRefsGroupMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.EarVersion;
import org.jboss.metadata.ear.spec.ModulesMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.ee.MessageDestinationMetaDataParser;
import org.jboss.metadata.parser.ee.SecurityRoleMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;

public class EarMetaDataParser
extends MetaDataElementParser {
    public static final EarMetaDataParser INSTANCE = new EarMetaDataParser();

    public EarMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return this.parse(reader, PropertyReplacers.noop());
    }

    public EarMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        int i;
        int count;
        reader.require(7, null, null);
        EarVersion version = null;
        while (reader.hasNext() && reader.next() != 1) {
            String dtdLocation;
            if (reader.getEventType() != 11 || (dtdLocation = EarMetaDataParser.readDTDLocation((XMLStreamReader)reader)) == null) continue;
            version = EarVersion.forLocation(dtdLocation);
        }
        String schemaLocation = EarMetaDataParser.readSchemaLocation((XMLStreamReader)reader);
        if (schemaLocation != null) {
            version = EarVersion.forLocation(schemaLocation);
        }
        if (version == null || EarVersion.UNKNOWN.equals((Object)version)) {
            String versionString = null;
            count = reader.getAttributeCount();
            for (i = 0; i < count; ++i) {
                Attribute attribute;
                if (EarMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i) || (attribute = Attribute.forName(reader.getAttributeLocalName(i))) != Attribute.VERSION) continue;
                versionString = reader.getAttributeValue(i);
            }
            if ("1.4".equals(versionString)) {
                version = EarVersion.APP_1_4;
            } else if ("5".equals(versionString)) {
                version = EarVersion.APP_5_0;
            } else if ("6".equals(versionString)) {
                version = EarVersion.APP_6_0;
            } else if ("7".equals(versionString)) {
                version = EarVersion.APP_7_0;
            } else if ("8".equals(versionString)) {
                version = EarVersion.APP_8_0;
            } else if ("9".equals(versionString)) {
                version = EarVersion.APP_9_0;
            }
        }
        if (version == null || EarVersion.UNKNOWN.equals((Object)version)) {
            version = EarVersion.APP_6_0;
        }
        EarMetaData earMetaData = new EarMetaData(version);
        count = reader.getAttributeCount();
        block6: for (i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (EarMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    earMetaData.setId(value);
                    continue block6;
                }
                case VERSION: {
                    continue block6;
                }
                default: {
                    throw EarMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        EarEnvironmentRefsGroupMetaData environmentRefsGroupMetaData = new EarEnvironmentRefsGroupMetaData();
        earMetaData.setDescriptionGroup(new DescriptionGroupMetaData());
        earMetaData.setModules(new ModulesMetaData());
        earMetaData.setSecurityRoles(new SecurityRolesMetaData());
        environmentRefsGroupMetaData.setMessageDestinations(new MessageDestinationsMetaData());
        earMetaData.setEarEnvironmentRefsGroup(environmentRefsGroupMetaData);
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.handleElement(reader, earMetaData, propertyReplacer);
        }
        return earMetaData;
    }

    protected void handleElement(XMLStreamReader reader, EarMetaData earMetaData, PropertyReplacer propertyReplacer) throws XMLStreamException {
        if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)earMetaData.getDescriptionGroup())) {
            return;
        }
        if (EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)earMetaData.getEarEnvironmentRefsGroup(), (PropertyReplacer)propertyReplacer)) {
            return;
        }
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case APPLICATION_NAME: {
                earMetaData.setApplicationName(EarMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                break;
            }
            case INITIALIZATION_IN_ORDER: {
                earMetaData.setInitializeInOrder(Boolean.parseBoolean(EarMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                break;
            }
            case LIBRARY_DIRECTORY: {
                earMetaData.setLibraryDirectory(EarMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                break;
            }
            case MESSAGE_DESTINATION: {
                earMetaData.getEarEnvironmentRefsGroup().getMessageDestinations().add((MappableMetaData)MessageDestinationMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                break;
            }
            case MODULE: {
                earMetaData.getModules().add((MappableMetaData)EarModuleMetaDataParser.parse(reader, propertyReplacer));
                break;
            }
            case SECURITY_ROLE: {
                earMetaData.getSecurityRoles().add((MappableMetaData)SecurityRoleMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                break;
            }
            default: {
                throw EarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }
}

