/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.common.model.validator.ModelValidationStepHandler;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerResourceDefinition;

public class DefaultAddStepHandler
extends ModelOnlyAddStepHandler {
    private final List<ModelValidationStepHandler> modelValidators = new ArrayList<ModelValidationStepHandler>();
    private final Function<PathAddress, PathAddress> partitionAddressProvider;

    DefaultAddStepHandler(ModelValidationStepHandler[] modelValidators, Function<PathAddress, PathAddress> partitionAddressProvider, AttributeDefinition ... attributes) {
        super(attributes);
        this.partitionAddressProvider = partitionAddressProvider;
        this.configureModelValidators(modelValidators);
    }

    private void configureModelValidators(ModelValidationStepHandler[] modelValidators) {
        if (modelValidators != null) {
            this.modelValidators.addAll(Arrays.asList(modelValidators));
        }
        if (this.partitionAddressProvider != null) {
            this.modelValidators.add(new ModelValidationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PartitionManagerResourceDefinition.validateModel(context, (PathAddress)DefaultAddStepHandler.this.partitionAddressProvider.apply(context.getCurrentAddress()));
                }
            });
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.performValidation(context);
        super.execute(context, operation);
    }

    protected void performValidation(OperationContext context) {
        for (ModelValidationStepHandler validatonStepHandler : this.modelValidators) {
            context.addStep((OperationStepHandler)validatonStepHandler, OperationContext.Stage.MODEL);
        }
    }
}

