/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import org.hibernate.search.util.impl.ClosingOperator;
import org.hibernate.search.util.impl.GenericCloseable;

public final class Closer<E extends Exception>
implements AutoCloseable {
    private final State state;

    public Closer() {
        this(new State());
    }

    private Closer(State state) {
        this.state = state;
    }

    public <T> void push(ClosingOperator<T, ? extends E> operator, T objectToClose) {
        try {
            operator.close(objectToClose);
        }
        catch (Throwable t) {
            this.state.addThrowable(this, t);
        }
    }

    public void push(GenericCloseable<? extends E> closeable) {
        this.push(GenericCloseable::close, closeable);
    }

    public <T> void pushAll(ClosingOperator<T, ? extends E> operator, Iterable<T> objectsToClose) {
        for (T objectToClose : objectsToClose) {
            this.push(operator, objectToClose);
        }
    }

    @SafeVarargs
    public final <T> void pushAll(ClosingOperator<T, ? extends E> operator, T ... objectsToClose) {
        for (T objectToClose : objectsToClose) {
            this.push(operator, objectToClose);
        }
    }

    public <E2 extends Exception> Closer<E2> split() {
        return new Closer<E>();
    }

    @Override
    public void close() throws E {
        this.state.close(this);
    }

    private static class State {
        private Closer<?> firstThrower;
        private Throwable firstThrowable;

        private State() {
        }

        public void addThrowable(Closer<?> source, Throwable throwable) {
            if (this.firstThrowable == null) {
                this.firstThrowable = throwable;
                this.firstThrower = source;
            } else {
                this.firstThrowable.addSuppressed(throwable);
            }
        }

        public <E extends Exception> void close(Closer<E> source) throws E {
            if (this.firstThrowable != null && source == this.firstThrower) {
                try {
                    if (this.firstThrowable instanceof RuntimeException) {
                        throw (RuntimeException)this.firstThrowable;
                    }
                    if (this.firstThrowable instanceof Error) {
                        throw (Error)this.firstThrowable;
                    }
                    if (this.firstThrowable != null) {
                        throw (Exception)this.firstThrowable;
                    }
                }
                finally {
                    this.firstThrower = null;
                    this.firstThrowable = null;
                }
            }
        }
    }
}

