/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.metadata.BundleItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModificationCondition;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBuilder;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchElementProvider;
import org.jboss.as.patching.metadata.PatchIdentityBuilder;
import org.jboss.as.patching.metadata.impl.PatchElementImpl;
import org.jboss.as.patching.metadata.impl.PatchElementProviderImpl;
import org.jboss.as.patching.metadata.impl.RequiresCallback;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class PatchXmlUtils
implements XMLStreamConstants {
    private static final String PATH_DELIMITER = "/";

    PatchXmlUtils() {
    }

    protected static void writePatch(XMLExtendedStreamWriter writer, Patch patch) throws XMLStreamException {
        Identity identity;
        Patch.PatchType type;
        String link;
        writer.writeAttribute(Attribute.ID.name, patch.getPatchId());
        String description = patch.getDescription();
        if (description != null) {
            writer.writeStartElement(Element.DESCRIPTION.name);
            writer.writeCharacters(description);
            writer.writeEndElement();
        }
        if ((link = patch.getLink()) != null) {
            writer.writeEmptyElement(Element.LINK.name);
            writer.writeAttribute(Attribute.URL.name, link);
        }
        if ((type = (identity = patch.getIdentity()).getPatchType()) == Patch.PatchType.CUMULATIVE) {
            writer.writeStartElement(Element.UPGRADE.name);
        } else {
            writer.writeStartElement(Element.NO_UPGRADE.name);
        }
        writer.writeAttribute(Attribute.NAME.name, identity.getName());
        writer.writeAttribute(Attribute.VERSION.name, identity.getVersion());
        if (type == Patch.PatchType.CUMULATIVE) {
            Identity.IdentityUpgrade upgrade = identity.forType(Patch.PatchType.CUMULATIVE, Identity.IdentityUpgrade.class);
            writer.writeAttribute(Attribute.TO_VERSION.name, upgrade.getResultingVersion());
        }
        if (!identity.getRequires().isEmpty()) {
            writer.writeStartElement(Element.REQUIRES.name);
            for (String patchId : identity.getRequires()) {
                writer.writeStartElement(Element.PATCH.name);
                writer.writeAttribute(Attribute.ID.name, patchId);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        List<PatchElement> elements = patch.getElements();
        for (PatchElement element : elements) {
            writer.writeStartElement(Element.PATCH_ELEMENT.name);
            writer.writeAttribute(Attribute.ID.name, element.getId());
            if (element.getDescription() != null) {
                writer.writeStartElement(Element.DESCRIPTION.name);
                writer.writeCharacters(element.getDescription());
                writer.writeEndElement();
            }
            PatchElementProvider provider = element.getProvider();
            assert (provider != null);
            Patch.PatchType elementPatchType = provider.getPatchType();
            if (elementPatchType == Patch.PatchType.CUMULATIVE) {
                writer.writeStartElement(Element.UPGRADE.name);
            } else {
                writer.writeStartElement(Element.NO_UPGRADE.name);
            }
            writer.writeAttribute(Attribute.NAME.name, provider.getName());
            if (provider.isAddOn()) {
                writer.writeAttribute(Attribute.ADD_ON.name, "true");
            }
            if (!provider.getRequires().isEmpty()) {
                writer.writeStartElement(Element.REQUIRES.name);
                for (String elementId : provider.getRequires()) {
                    writer.writeStartElement(Element.PATCH.name);
                    writer.writeAttribute(Attribute.ID.name, elementId);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            PatchXmlUtils.writeContentModifications(writer, element.getModifications());
            writer.writeEndElement();
        }
        PatchXmlUtils.writeContentModifications(writer, patch.getModifications());
    }

    protected static void writeContentModifications(XMLExtendedStreamWriter writer, Collection<ContentModification> modifications) throws XMLStreamException {
        ArrayList<ContentModification> bundlesAdd = new ArrayList<ContentModification>();
        ArrayList<ContentModification> bundlesUpdate = new ArrayList<ContentModification>();
        ArrayList<ContentModification> bundlesRemove = new ArrayList<ContentModification>();
        ArrayList<ContentModification> miscAdd = new ArrayList<ContentModification>();
        ArrayList<ContentModification> miscUpdate = new ArrayList<ContentModification>();
        ArrayList<ContentModification> miscRemove = new ArrayList<ContentModification>();
        ArrayList<ContentModification> modulesAdd = new ArrayList<ContentModification>();
        ArrayList<ContentModification> modulesUpdate = new ArrayList<ContentModification>();
        ArrayList<ContentModification> modulesRemove = new ArrayList<ContentModification>();
        for (ContentModification mod : modifications) {
            ModificationType modificationType = mod.getType();
            ContentType contentType = mod.getItem().getContentType();
            block0 : switch (contentType) {
                case BUNDLE: {
                    switch (modificationType) {
                        case ADD: {
                            bundlesAdd.add(mod);
                            break block0;
                        }
                        case MODIFY: {
                            bundlesUpdate.add(mod);
                            break block0;
                        }
                        case REMOVE: {
                            bundlesRemove.add(mod);
                        }
                    }
                    break;
                }
                case MODULE: {
                    switch (modificationType) {
                        case ADD: {
                            modulesAdd.add(mod);
                            break block0;
                        }
                        case MODIFY: {
                            modulesUpdate.add(mod);
                            break block0;
                        }
                        case REMOVE: {
                            modulesRemove.add(mod);
                        }
                    }
                    break;
                }
                case MISC: {
                    switch (modificationType) {
                        case ADD: {
                            miscAdd.add(mod);
                            break block0;
                        }
                        case MODIFY: {
                            miscUpdate.add(mod);
                            break block0;
                        }
                        case REMOVE: {
                            miscRemove.add(mod);
                        }
                    }
                }
            }
        }
        if (!(modulesAdd.isEmpty() && modulesUpdate.isEmpty() && modulesRemove.isEmpty())) {
            writer.writeStartElement(Element.MODULES.name);
            PatchXmlUtils.writeSlottedItems(writer, Element.ADDED, modulesAdd);
            PatchXmlUtils.writeSlottedItems(writer, Element.UPDATED, modulesUpdate);
            PatchXmlUtils.writeSlottedItems(writer, Element.REMOVED, modulesRemove);
            writer.writeEndElement();
        }
        if (!(bundlesAdd.isEmpty() && bundlesUpdate.isEmpty() && bundlesRemove.isEmpty())) {
            writer.writeStartElement(Element.BUNDLES.name);
            PatchXmlUtils.writeSlottedItems(writer, Element.ADDED, bundlesAdd);
            PatchXmlUtils.writeSlottedItems(writer, Element.UPDATED, bundlesUpdate);
            PatchXmlUtils.writeSlottedItems(writer, Element.REMOVED, bundlesRemove);
            writer.writeEndElement();
        }
        if (!(miscAdd.isEmpty() && miscUpdate.isEmpty() && miscRemove.isEmpty())) {
            writer.writeStartElement(Element.MISC_FILES.name);
            PatchXmlUtils.writeMiscItems(writer, Element.ADDED, miscAdd);
            PatchXmlUtils.writeMiscItems(writer, Element.UPDATED, miscUpdate);
            PatchXmlUtils.writeMiscItems(writer, Element.REMOVED, miscRemove);
            writer.writeEndElement();
        }
    }

    protected void doReadElement(XMLExtendedStreamReader reader, PatchBuilder builder, InstalledIdentity originalIdentity) throws XMLStreamException {
        PatchBuilder patch = builder;
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (Attribute.ID != attribute) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            patch.setPatchId(value);
        }
        List<ContentModification> modifications = patch.getModifications();
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case DESCRIPTION: {
                    patch.setDescription(reader.getElementText());
                    continue block11;
                }
                case LINK: {
                    String link = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.URL.name);
                    builder.setLink(link);
                    continue block11;
                }
                case UPGRADE: {
                    PatchXmlUtils.parseIdentity(reader, patch, Patch.PatchType.CUMULATIVE);
                    continue block11;
                }
                case NO_UPGRADE: {
                    PatchXmlUtils.parseIdentity(reader, patch, Patch.PatchType.ONE_OFF);
                    continue block11;
                }
                case PATCH_ELEMENT: {
                    PatchXmlUtils.parseElement(reader, patch);
                    continue block11;
                }
                case MODULES: {
                    PatchXmlUtils.parseModules(reader, modifications);
                    continue block11;
                }
                case BUNDLES: {
                    PatchXmlUtils.parseBundles(reader, modifications);
                    continue block11;
                }
                case MISC_FILES: {
                    PatchXmlUtils.parseMiscFiles(reader, modifications);
                    continue block11;
                }
            }
            this.handleRootElement(localName, reader, patch, originalIdentity);
        }
    }

    protected void handleRootElement(String localName, XMLExtendedStreamReader reader, PatchBuilder builder, InstalledIdentity originalIdentity) throws XMLStreamException {
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    static void parseElement(XMLExtendedStreamReader reader, PatchBuilder builder) throws XMLStreamException {
        String id = null;
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (Attribute.ID != attribute) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            id = value;
        }
        PatchElementImpl patchElement = new PatchElementImpl(id);
        try {
            builder.addElement(patchElement);
        }
        catch (IllegalStateException e) {
            throw new XMLStreamException(e);
        }
        Collection modifications = patchElement.getModifications();
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    patchElement.setDescription(reader.getElementText());
                    continue block11;
                }
                case UPGRADE: {
                    PatchXmlUtils.parseElementProvider(reader, patchElement, Patch.PatchType.CUMULATIVE);
                    continue block11;
                }
                case NO_UPGRADE: {
                    PatchXmlUtils.parseElementProvider(reader, patchElement, Patch.PatchType.ONE_OFF);
                    continue block11;
                }
                case MODULES: {
                    PatchXmlUtils.parseModules(reader, modifications);
                    continue block11;
                }
                case BUNDLES: {
                    PatchXmlUtils.parseBundles(reader, modifications);
                    continue block11;
                }
                case MISC_FILES: {
                    PatchXmlUtils.parseMiscFiles(reader, modifications);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseElementProvider(XMLExtendedStreamReader reader, PatchElementImpl patchElement, Patch.PatchType patchType) throws XMLStreamException {
        String name = null;
        boolean isAddOn = false;
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (Attribute.NAME == attribute) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (Attribute.ADD_ON == attribute) {
                isAddOn = Boolean.valueOf(reader.getAttributeValue(i));
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        PatchElementProviderImpl provider = new PatchElementProviderImpl(name, isAddOn);
        patchElement.setProvider(provider);
        switch (patchType) {
            case CUMULATIVE: {
                provider.upgrade();
                break;
            }
            case ONE_OFF: {
                provider.oneOffPatch();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int level = 0;
        block9: while (reader.hasNext()) {
            if (reader.nextTag() == 2) {
                if (level == 0) break;
                --level;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REQUIRES: {
                    continue block9;
                }
                case PATCH: {
                    level = 1;
                    PatchXmlUtils.parseIncluded(reader, provider);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseIdentity(XMLExtendedStreamReader reader, PatchBuilder builder, Patch.PatchType patchType) throws XMLStreamException {
        PatchIdentityBuilder identityBuilder;
        String name = null;
        String version = null;
        String resultingVersion = null;
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (Attribute.VERSION == attribute) {
                version = reader.getAttributeValue(i);
                continue;
            }
            if (Attribute.TO_VERSION == attribute) {
                resultingVersion = reader.getAttributeValue(i);
                continue;
            }
            if (Attribute.NAME == attribute) {
                name = reader.getAttributeValue(i);
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        switch (patchType) {
            case CUMULATIVE: {
                identityBuilder = builder.upgradeIdentity(name, version, resultingVersion);
                break;
            }
            case ONE_OFF: {
                identityBuilder = builder.oneOffPatchIdentity(name, version);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int level = 0;
        block9: while (reader.hasNext()) {
            if (reader.nextTag() == 2) {
                if (level == 0) break;
                --level;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REQUIRES: {
                    continue block9;
                }
                case PATCH: {
                    level = 1;
                    PatchXmlUtils.parseIncluded(reader, identityBuilder);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseIncluded(XMLExtendedStreamReader reader, RequiresCallback includes) throws XMLStreamException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (Attribute.ID != attribute) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            includes.require(value);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void parseModules(XMLExtendedStreamReader reader, Collection<ContentModification> modifications) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDED: {
                    modifications.add(PatchXmlUtils.parseModuleModification(reader, ModificationType.ADD));
                    continue block5;
                }
                case UPDATED: {
                    modifications.add(PatchXmlUtils.parseModuleModification(reader, ModificationType.MODIFY));
                    continue block5;
                }
                case REMOVED: {
                    modifications.add(PatchXmlUtils.parseModuleModification(reader, ModificationType.REMOVE));
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseMiscFiles(XMLExtendedStreamReader reader, Collection<ContentModification> modifications) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDED: {
                    modifications.add(PatchXmlUtils.parseMiscModification(reader, ModificationType.ADD));
                    continue block5;
                }
                case UPDATED: {
                    modifications.add(PatchXmlUtils.parseMiscModification(reader, ModificationType.MODIFY));
                    continue block5;
                }
                case REMOVED: {
                    modifications.add(PatchXmlUtils.parseMiscModification(reader, ModificationType.REMOVE));
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseBundles(XMLExtendedStreamReader reader, Collection<ContentModification> modifications) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDED: {
                    modifications.add(PatchXmlUtils.parseBundleModification(reader, ModificationType.ADD));
                    continue block5;
                }
                case UPDATED: {
                    modifications.add(PatchXmlUtils.parseBundleModification(reader, ModificationType.MODIFY));
                    continue block5;
                }
                case REMOVED: {
                    modifications.add(PatchXmlUtils.parseBundleModification(reader, ModificationType.REMOVE));
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ContentModification parseBundleModification(XMLExtendedStreamReader reader, ModificationType type) throws XMLStreamException {
        return PatchXmlUtils.parseSlottedItem(reader, type, ContentType.BUNDLE);
    }

    static ContentModification parseModuleModification(XMLExtendedStreamReader reader, ModificationType type) throws XMLStreamException {
        return PatchXmlUtils.parseSlottedItem(reader, type, ContentType.MODULE);
    }

    static ContentModification parseSlottedItem(XMLExtendedStreamReader reader, ModificationType modificationType, ContentType contentType) throws XMLStreamException {
        String moduleName = null;
        String slot = "main";
        byte[] hash = IoUtils.NO_CONTENT;
        byte[] targetHash = IoUtils.NO_CONTENT;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    moduleName = reader.getAttributeValue(i);
                    continue block6;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block6;
                }
                case HASH: {
                    if (modificationType == ModificationType.REMOVE) {
                        targetHash = HashUtils.hexStringToByteArray(reader.getAttributeValue(i));
                        continue block6;
                    }
                    hash = HashUtils.hexStringToByteArray(reader.getAttributeValue(i));
                    continue block6;
                }
                case NEW_HASH: {
                    if (modificationType == ModificationType.REMOVE) {
                        hash = HashUtils.hexStringToByteArray(reader.getAttributeValue(i));
                        continue block6;
                    }
                    targetHash = HashUtils.hexStringToByteArray(reader.getAttributeValue(i));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModuleItem item = contentType == ContentType.MODULE ? new ModuleItem(moduleName, slot, hash) : new BundleItem(moduleName, slot, hash);
        return new ContentModification(item, targetHash, modificationType);
    }

    static ContentModification parseMiscModification(XMLExtendedStreamReader reader, ModificationType type) throws XMLStreamException {
        String path = null;
        byte[] hash = IoUtils.NO_CONTENT;
        boolean directory = false;
        boolean affectsRuntime = false;
        byte[] targetHash = IoUtils.NO_CONTENT;
        ModificationCondition condition = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DIRECTORY: {
                    directory = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block10;
                }
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block10;
                }
                case HASH: {
                    if (type == ModificationType.REMOVE) {
                        targetHash = HashUtils.hexStringToByteArray(reader.getAttributeValue(i));
                        continue block10;
                    }
                    hash = HashUtils.hexStringToByteArray(reader.getAttributeValue(i));
                    continue block10;
                }
                case NEW_HASH: {
                    if (type == ModificationType.REMOVE) {
                        hash = HashUtils.hexStringToByteArray(reader.getAttributeValue(i));
                        continue block10;
                    }
                    targetHash = HashUtils.hexStringToByteArray(reader.getAttributeValue(i));
                    continue block10;
                }
                case IN_RUNTIME_USE: {
                    affectsRuntime = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block10;
                }
                case CONDITION: {
                    try {
                        condition = ModificationCondition.Factory.fromString(reader.getAttributeValue(i));
                        continue block10;
                    }
                    catch (PatchingException e) {
                        throw ControllerLogger.ROOT_LOGGER.invalidAttributeValue(reader.getAttributeValue(i), new QName(attribute.name), reader.getLocation());
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        MiscContentItem item = PatchXmlUtils.createMiscItem(path, hash, directory, affectsRuntime);
        return new ContentModification(item, targetHash, type, condition);
    }

    private static MiscContentItem createMiscItem(String path, byte[] hash, boolean directory, boolean affectsRuntime) {
        String[] s = path.split(PATH_DELIMITER);
        int length = s.length;
        String name = s[length - 1];
        String[] itemPath = Arrays.copyOf(s, length - 1);
        return new MiscContentItem(name, itemPath, hash, directory, affectsRuntime);
    }

    protected static void writeAppliesToVersions(XMLExtendedStreamWriter writer, List<String> appliesTo) throws XMLStreamException {
        for (String version : appliesTo) {
            writer.writeCharacters(version);
            writer.writeEndElement();
        }
    }

    protected static void writeSlottedItems(XMLExtendedStreamWriter writer, Element element, List<ContentModification> modifications) throws XMLStreamException {
        for (ContentModification modification : modifications) {
            PatchXmlUtils.writeSlottedItem(writer, element, modification);
        }
    }

    protected static void writeSlottedItem(XMLExtendedStreamWriter writer, Element element, ContentModification modification) throws XMLStreamException {
        byte[] existingHash;
        byte[] hash;
        writer.writeEmptyElement(element.name);
        ModuleItem item = (ModuleItem)modification.getItem();
        ModificationType type = modification.getType();
        writer.writeAttribute(Attribute.NAME.name, item.getName());
        if (!"main".equals(item.getSlot())) {
            writer.writeAttribute(Attribute.SLOT.name, item.getSlot());
        }
        if ((hash = item.getContentHash()).length > 0 && type != ModificationType.REMOVE) {
            writer.writeAttribute(Attribute.HASH.name, HashUtils.bytesToHexString(hash));
        }
        if (type == ModificationType.REMOVE) {
            byte[] existingHash2 = modification.getTargetHash();
            if (existingHash2.length > 0) {
                writer.writeAttribute(Attribute.HASH.name, HashUtils.bytesToHexString(existingHash2));
            }
        } else if (type == ModificationType.MODIFY && (existingHash = modification.getTargetHash()).length > 0) {
            writer.writeAttribute(Attribute.NEW_HASH.name, HashUtils.bytesToHexString(existingHash));
        }
    }

    protected static void writeMiscItems(XMLExtendedStreamWriter writer, Element element, List<ContentModification> modifications) throws XMLStreamException {
        for (ContentModification modification : modifications) {
            PatchXmlUtils.writeMiscItem(writer, element, modification);
        }
    }

    protected static void writeMiscItem(XMLExtendedStreamWriter writer, Element element, ContentModification modification) throws XMLStreamException {
        ModificationCondition condition;
        writer.writeEmptyElement(element.name);
        MiscContentItem item = (MiscContentItem)modification.getItem();
        ModificationType type = modification.getType();
        StringBuilder path = new StringBuilder();
        for (String p : item.getPath()) {
            path.append(p).append(PATH_DELIMITER);
        }
        path.append(item.getName());
        writer.writeAttribute(Attribute.PATH.name, path.toString());
        if (item.isDirectory()) {
            writer.writeAttribute(Attribute.DIRECTORY.name, "true");
        }
        if ((condition = modification.getCondition()) != null) {
            writer.writeAttribute(Attribute.CONDITION.name, condition.toString());
        }
        if (type == ModificationType.REMOVE) {
            byte[] existingHash = modification.getTargetHash();
            if (existingHash.length > 0) {
                writer.writeAttribute(Attribute.HASH.name, HashUtils.bytesToHexString(existingHash));
            }
            if (item.isAffectsRuntime()) {
                writer.writeAttribute(Attribute.IN_RUNTIME_USE.name, "true");
            }
        } else {
            byte[] hash = item.getContentHash();
            if (hash.length > 0) {
                writer.writeAttribute(Attribute.HASH.name, HashUtils.bytesToHexString(hash));
            }
            if (type == ModificationType.MODIFY) {
                writer.writeAttribute(Attribute.NEW_HASH.name, HashUtils.bytesToHexString(modification.getTargetHash()));
                if (item.isAffectsRuntime()) {
                    writer.writeAttribute(Attribute.IN_RUNTIME_USE.name, "true");
                }
            }
        }
    }

    static enum Attribute {
        ADD_ON("add-on"),
        DIRECTORY("directory"),
        EXISTING_PATH("existing-path"),
        HASH("hash"),
        ID("id"),
        IN_RUNTIME_USE("in-runtime-use"),
        NAME("name"),
        NEW_HASH("new-hash"),
        PATH("path"),
        CONDITION("condition"),
        SLOT("slot"),
        TO_VERSION("to-version"),
        URL("url"),
        VERSION("version"),
        UNKNOWN(null);

        private final String name;
        static Map<String, Attribute> attributes;

        private Attribute(String name) {
            this.name = name;
        }

        static Attribute forName(String name) {
            Attribute attribute = attributes.get(name);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            attributes = new HashMap<String, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                if (attribute == UNKNOWN) continue;
                attributes.put(attribute.name, attribute);
            }
        }
    }

    static enum Element {
        ADDED("added"),
        BUNDLES("bundles"),
        DESCRIPTION("description"),
        IDENTITY("identity"),
        REQUIRES("requires"),
        LINK("link"),
        MISC_FILES("misc-files"),
        MODULES("modules"),
        NO_UPGRADE("no-upgrade"),
        ONE_OFF("one-off"),
        PATCH("patch"),
        PATCH_ELEMENT("element"),
        REMOVED("removed"),
        UPDATED("updated"),
        UPGRADE("upgrade"),
        UNKNOWN(null);

        public final String name;
        static Map<String, Element> elements;

        private Element(String name) {
            this.name = name;
        }

        static Element forName(String name) {
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            elements = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                if (element == UNKNOWN) continue;
                elements.put(element.name, element);
            }
        }
    }
}

