/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.AttributeValidator;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;
import org.infinispan.xsite.spi.XSiteMergePolicy;

public class SitesConfiguration
extends ConfigurationElement<SitesConfiguration> {
    public static final AttributeDefinition<Boolean> DISABLE_BACKUPS = AttributeDefinition.builder((String)"disable", (Object)false).immutable().build();
    public static final AttributeDefinition<Set<String>> IN_USE_BACKUP_SITES = AttributeDefinition.builder((String)"backup-sites-in-use", null, Set.class).initializer(() -> new HashSet(2)).autoPersist(false).immutable().build();
    public static final AttributeDefinition<XSiteEntryMergePolicy> MERGE_POLICY = AttributeDefinition.builder((Enum)Attribute.MERGE_POLICY, (Object)XSiteMergePolicy.DEFAULT, XSiteEntryMergePolicy.class).copier((AttributeCopier)new MergePolicyAttributeCopier()).immutable().build();
    public static final AttributeDefinition<Long> MAX_CLEANUP_DELAY = AttributeDefinition.builder((Enum)Attribute.MAX_CLEANUP_DELAY, (Object)30000L).validator(AttributeValidator.greaterThanZero((Enum)Attribute.MAX_CLEANUP_DELAY)).immutable().build();
    public static final AttributeDefinition<Integer> TOMBSTONE_MAP_SIZE = AttributeDefinition.builder((Enum)Attribute.TOMBSTONE_MAP_SIZE, (Object)512000).validator(AttributeValidator.greaterThanZero((Enum)Attribute.TOMBSTONE_MAP_SIZE)).immutable().build();
    private final BackupForConfiguration backupFor;
    private final List<BackupConfiguration> allBackups;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> disableBackups;
    private final org.infinispan.commons.configuration.attributes.Attribute<XSiteEntryMergePolicy> mergePolicy;
    private final org.infinispan.commons.configuration.attributes.Attribute<Set<String>> inUseBackupSites;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SitesConfiguration.class, new AttributeDefinition[]{DISABLE_BACKUPS, IN_USE_BACKUP_SITES, MERGE_POLICY, MAX_CLEANUP_DELAY, TOMBSTONE_MAP_SIZE});
    }

    public SitesConfiguration(AttributeSet attributes, List<BackupConfiguration> allBackups, BackupForConfiguration backupFor) {
        super((Enum)Element.SITES, attributes, new ConfigurationElement[]{ConfigurationElement.list((Enum)Element.BACKUPS, allBackups), backupFor});
        this.allBackups = Collections.unmodifiableList(allBackups);
        this.disableBackups = attributes.attribute(DISABLE_BACKUPS);
        this.inUseBackupSites = attributes.attribute(IN_USE_BACKUP_SITES);
        this.mergePolicy = attributes.attribute(MERGE_POLICY);
        this.backupFor = backupFor;
    }

    public boolean disableBackups() {
        return (Boolean)this.disableBackups.get();
    }

    public List<BackupConfiguration> allBackups() {
        return this.allBackups;
    }

    public List<BackupConfiguration> enabledBackups() {
        return this.enabledBackupStream().collect(Collectors.toList());
    }

    public Stream<BackupConfiguration> enabledBackupStream() {
        return this.allBackups.stream().filter(BackupConfiguration::enabled);
    }

    public BackupForConfiguration backupFor() {
        return this.backupFor;
    }

    public BackupFailurePolicy getFailurePolicy(String siteName) {
        for (BackupConfiguration bc : this.allBackups) {
            if (!bc.site().equals(siteName)) continue;
            return bc.backupFailurePolicy();
        }
        throw new IllegalStateException("There must be a site configured for " + siteName);
    }

    public boolean hasInUseBackup(String siteName) {
        for (BackupConfiguration bc : this.allBackups) {
            if (!bc.site().equals(siteName)) continue;
            return bc.enabled();
        }
        return false;
    }

    public boolean hasEnabledBackups() {
        return this.allBackups.stream().anyMatch(BackupConfiguration::enabled);
    }

    public boolean hasSyncEnabledBackups() {
        return this.enabledBackupStream().anyMatch(BackupConfiguration::isSyncBackup);
    }

    public Stream<BackupConfiguration> syncBackupsStream() {
        return this.enabledBackupStream().filter(BackupConfiguration::isSyncBackup);
    }

    public boolean hasAsyncEnabledBackups() {
        return this.enabledBackupStream().anyMatch(BackupConfiguration::isAsyncBackup);
    }

    public Stream<BackupConfiguration> asyncBackupsStream() {
        return this.enabledBackupStream().filter(BackupConfiguration::isAsyncBackup);
    }

    public Set<String> inUseBackupSites() {
        return (Set)this.inUseBackupSites.get();
    }

    public XSiteEntryMergePolicy<?, ?> mergePolicy() {
        return (XSiteEntryMergePolicy)this.mergePolicy.get();
    }

    public long maxTombstoneCleanupDelay() {
        return (Long)this.attributes.attribute(MAX_CLEANUP_DELAY).get();
    }

    public int tombstoneMapSize() {
        return (Integer)this.attributes.attribute(TOMBSTONE_MAP_SIZE).get();
    }

    private static class MergePolicyAttributeCopier
    implements AttributeCopier<XSiteEntryMergePolicy> {
        private MergePolicyAttributeCopier() {
        }

        public XSiteEntryMergePolicy copyAttribute(XSiteEntryMergePolicy attribute) {
            if (attribute == null) {
                return null;
            }
            if (attribute instanceof XSiteMergePolicy) {
                return ((XSiteMergePolicy)attribute).getInstance();
            }
            return (XSiteEntryMergePolicy)Util.getInstance(attribute.getClass());
        }
    }
}

