/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.operation;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.ObjectWriter;
import io.smallrye.openapi.runtime.io.callback.CallbackWriter;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsWriter;
import io.smallrye.openapi.runtime.io.parameter.ParameterWriter;
import io.smallrye.openapi.runtime.io.requestbody.RequestBodyWriter;
import io.smallrye.openapi.runtime.io.response.ResponseWriter;
import io.smallrye.openapi.runtime.io.securityrequirement.SecurityRequirementWriter;
import io.smallrye.openapi.runtime.io.server.ServerWriter;
import org.eclipse.microprofile.openapi.models.Operation;

public class OperationWriter {
    private OperationWriter() {
    }

    public static void writeOperation(ObjectNode parent, Operation model, String method) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(method);
        ObjectWriter.writeStringArray(node, model.getTags(), "tags");
        JsonUtil.stringProperty(node, "summary", model.getSummary());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        ExternalDocsWriter.writeExternalDocumentation(node, model.getExternalDocs());
        JsonUtil.stringProperty(node, "operationId", model.getOperationId());
        ParameterWriter.writeParameterList(node, model.getParameters());
        RequestBodyWriter.writeRequestBody(node, model.getRequestBody());
        ResponseWriter.writeAPIResponses(node, model.getResponses());
        CallbackWriter.writeCallbacks(node, model.getCallbacks());
        JsonUtil.booleanProperty(node, "deprecated", model.getDeprecated());
        SecurityRequirementWriter.writeSecurityRequirements(node, model.getSecurity());
        ServerWriter.writeServers(node, model.getServers());
        ExtensionWriter.writeExtensions(node, model);
    }
}

