/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedCallable;
import io.opentracing.contrib.concurrent.TracedExecutor;
import io.opentracing.contrib.concurrent.TracedRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TracedExecutorService
extends TracedExecutor
implements ExecutorService {
    private final ExecutorService delegate;

    public TracedExecutorService(ExecutorService delegate, Tracer tracer) {
        this(delegate, tracer, true);
    }

    public TracedExecutorService(ExecutorService delegate, Tracer tracer, boolean traceWithActiveSpanOnly) {
        super(delegate, tracer, traceWithActiveSpanOnly);
        this.delegate = delegate;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        Span span = this.createSpan("submit");
        try {
            Span toActivate = span != null ? span : this.tracer.activeSpan();
            Future future = this.delegate.submit(toActivate == null ? callable : new TracedCallable(callable, this.tracer, toActivate));
            return future;
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        Span span = this.createSpan("submit");
        try {
            Span toActivate = span != null ? span : this.tracer.activeSpan();
            Future<T> future = this.delegate.submit(toActivate == null ? runnable : new TracedRunnable(runnable, this.tracer, toActivate), t);
            return future;
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> submit(Runnable runnable) {
        Span span = this.createSpan("submit");
        try {
            Span toActivate = span != null ? span : this.tracer.activeSpan();
            Future<?> future = this.delegate.submit(toActivate == null ? runnable : new TracedRunnable(runnable, this.tracer, toActivate));
            return future;
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        Span span = this.createSpan("invokeAll");
        try {
            Span toActivate = span != null ? span : this.tracer.activeSpan();
            List<Future<T>> list = this.delegate.invokeAll(this.toTraced(collection, toActivate));
            return list;
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        Span span = this.createSpan("invokeAll");
        try {
            Span toActivate = span != null ? span : this.tracer.activeSpan();
            List<Future<T>> list = this.delegate.invokeAll(this.toTraced(collection, toActivate), l, timeUnit);
            return list;
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        Span span = this.createSpan("invokeAny");
        try {
            Span toActivate = span != null ? span : this.tracer.activeSpan();
            T t = this.delegate.invokeAny(this.toTraced(collection, toActivate));
            return t;
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Span span = this.createSpan("invokeAny");
        try {
            Span toActivate = span != null ? span : this.tracer.activeSpan();
            T t = this.delegate.invokeAny(this.toTraced(collection, toActivate), l, timeUnit);
            return t;
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    private <T> Collection<? extends Callable<T>> toTraced(Collection<? extends Callable<T>> delegate, Span toActivate) {
        ArrayList tracedCallables = new ArrayList(delegate.size());
        for (TracedCallable tracedCallable : delegate) {
            tracedCallables.add(toActivate == null ? tracedCallable : new TracedCallable(tracedCallable, this.tracer, toActivate));
        }
        return tracedCallables;
    }
}

