/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.rmi.marshal;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.rmi.RmiIdlUtil;
import org.wildfly.iiop.openjdk.rmi.marshal.CDRStreamReader;
import org.wildfly.iiop.openjdk.rmi.marshal.CDRStreamWriter;

public class CDRStream {
    public static String abbrevFor(Class clz) {
        if (clz == Boolean.TYPE) {
            return "Z";
        }
        if (clz == Byte.TYPE) {
            return "B";
        }
        if (clz == Character.TYPE) {
            return "C";
        }
        if (clz == Double.TYPE) {
            return "D";
        }
        if (clz == Float.TYPE) {
            return "F";
        }
        if (clz == Integer.TYPE) {
            return "I";
        }
        if (clz == Long.TYPE) {
            return "J";
        }
        if (clz == Short.TYPE) {
            return "S";
        }
        if (clz == Void.TYPE) {
            return "V";
        }
        if (clz == String.class) {
            return "G";
        }
        if (RmiIdlUtil.isRMIIDLRemoteInterface(clz)) {
            return "R" + clz.getName();
        }
        if (clz == Object.class) {
            return "M";
        }
        if (Object.class.isAssignableFrom(clz)) {
            return "N" + clz.getName();
        }
        if (IDLEntity.class.isAssignableFrom(clz)) {
            return "L" + clz.getName();
        }
        if (clz == Serializable.class) {
            return "E";
        }
        if (RmiIdlUtil.isAbstractInterface(clz)) {
            return "A";
        }
        if (Serializable.class.isAssignableFrom(clz)) {
            return "L" + clz.getName();
        }
        if (Externalizable.class.isAssignableFrom(clz)) {
            return "X";
        }
        if (clz == java.lang.Object.class) {
            return "O";
        }
        return "L" + clz.getName();
    }

    public static CDRStreamReader readerFor(String s, ClassLoader cl) {
        switch (s.charAt(0)) {
            case 'A': {
                return AbstractInterfaceReader.instance;
            }
            case 'B': {
                return ByteReader.instance;
            }
            case 'C': {
                return CharReader.instance;
            }
            case 'D': {
                return DoubleReader.instance;
            }
            case 'E': {
                return SerializableReader.instance;
            }
            case 'F': {
                return FloatReader.instance;
            }
            case 'G': {
                return StringReader.instance;
            }
            case 'I': {
                return IntReader.instance;
            }
            case 'J': {
                return LongReader.instance;
            }
            case 'L': {
                try {
                    return new ValuetypeReader(Class.forName(s.substring(1), true, cl));
                }
                catch (ClassNotFoundException e) {
                    throw IIOPLogger.ROOT_LOGGER.errorLoadingClass(s.substring(1), e);
                }
            }
            case 'M': {
                return CorbaObjectReader.instance;
            }
            case 'N': {
                try {
                    return new IdlInterfaceReader(cl.loadClass(s.substring(1)));
                }
                catch (ClassNotFoundException e) {
                    throw IIOPLogger.ROOT_LOGGER.errorLoadingClass(s.substring(1), e);
                }
            }
            case 'O': {
                return ObjectReader.instance;
            }
            case 'R': {
                try {
                    return new RemoteReader(cl.loadClass(s.substring(1)));
                }
                catch (ClassNotFoundException e) {
                    throw IIOPLogger.ROOT_LOGGER.errorLoadingClass(s.substring(1), e);
                }
            }
            case 'S': {
                return ShortReader.instance;
            }
            case 'V': {
                return null;
            }
            case 'X': {
                return ExternalizableReader.instance;
            }
            case 'Z': {
                return BooleanReader.instance;
            }
        }
        return null;
    }

    public static CDRStreamWriter writerFor(String s, ClassLoader cl) {
        switch (s.charAt(0)) {
            case 'A': {
                return AbstractInterfaceWriter.instance;
            }
            case 'B': {
                return ByteWriter.instance;
            }
            case 'C': {
                return CharWriter.instance;
            }
            case 'D': {
                return DoubleWriter.instance;
            }
            case 'E': {
                return SerializableWriter.instance;
            }
            case 'F': {
                return FloatWriter.instance;
            }
            case 'G': {
                return StringWriter.instance;
            }
            case 'I': {
                return IntWriter.instance;
            }
            case 'J': {
                return LongWriter.instance;
            }
            case 'L': {
                try {
                    return new ValuetypeWriter(Class.forName(s.substring(1), true, cl));
                }
                catch (ClassNotFoundException e) {
                    throw IIOPLogger.ROOT_LOGGER.errorLoadingClass(s.substring(1), e);
                }
            }
            case 'M': {
                return CorbaObjectWriter.instance;
            }
            case 'N': {
                try {
                    return new IdlInterfaceWriter(cl.loadClass(s.substring(1)));
                }
                catch (ClassNotFoundException e) {
                    throw IIOPLogger.ROOT_LOGGER.errorLoadingClass(s.substring(1), e);
                }
            }
            case 'O': {
                return ObjectWriter.instance;
            }
            case 'R': {
                return RemoteWriter.instance;
            }
            case 'S': {
                return ShortWriter.instance;
            }
            case 'V': {
                return null;
            }
            case 'X': {
                return ExternalizableWriter.instance;
            }
            case 'Z': {
                return BooleanWriter.instance;
            }
        }
        return null;
    }

    public static CDRStreamReader readerFor(Class clz) {
        if (clz == Boolean.TYPE) {
            return BooleanReader.instance;
        }
        if (clz == Byte.TYPE) {
            return ByteReader.instance;
        }
        if (clz == Character.TYPE) {
            return CharReader.instance;
        }
        if (clz == Double.TYPE) {
            return DoubleReader.instance;
        }
        if (clz == Float.TYPE) {
            return FloatReader.instance;
        }
        if (clz == Integer.TYPE) {
            return IntReader.instance;
        }
        if (clz == Long.TYPE) {
            return LongReader.instance;
        }
        if (clz == Short.TYPE) {
            return ShortReader.instance;
        }
        if (clz == Void.TYPE) {
            return null;
        }
        if (clz == String.class) {
            return StringReader.instance;
        }
        if (RmiIdlUtil.isRMIIDLRemoteInterface(clz)) {
            return new RemoteReader(clz);
        }
        if (clz == Object.class) {
            return CorbaObjectReader.instance;
        }
        if (Object.class.isAssignableFrom(clz)) {
            return new IdlInterfaceReader(clz);
        }
        if (IDLEntity.class.isAssignableFrom(clz)) {
            return new ValuetypeReader(clz);
        }
        if (clz == Serializable.class) {
            return SerializableReader.instance;
        }
        if (RmiIdlUtil.isAbstractInterface(clz)) {
            return AbstractInterfaceReader.instance;
        }
        if (Serializable.class.isAssignableFrom(clz)) {
            return new ValuetypeReader(clz);
        }
        if (Externalizable.class.isAssignableFrom(clz)) {
            return ExternalizableReader.instance;
        }
        if (clz == java.lang.Object.class) {
            return ObjectReader.instance;
        }
        return new ValuetypeReader(clz);
    }

    public static CDRStreamWriter writerFor(Class clz) {
        if (clz == Boolean.TYPE) {
            return BooleanWriter.instance;
        }
        if (clz == Byte.TYPE) {
            return ByteWriter.instance;
        }
        if (clz == Character.TYPE) {
            return CharWriter.instance;
        }
        if (clz == Double.TYPE) {
            return DoubleWriter.instance;
        }
        if (clz == Float.TYPE) {
            return FloatWriter.instance;
        }
        if (clz == Integer.TYPE) {
            return IntWriter.instance;
        }
        if (clz == Long.TYPE) {
            return LongWriter.instance;
        }
        if (clz == Short.TYPE) {
            return ShortWriter.instance;
        }
        if (clz == String.class) {
            return StringWriter.instance;
        }
        if (clz == Void.TYPE) {
            return null;
        }
        if (RmiIdlUtil.isRMIIDLRemoteInterface(clz)) {
            return RemoteWriter.instance;
        }
        if (clz == Object.class) {
            return CorbaObjectWriter.instance;
        }
        if (Object.class.isAssignableFrom(clz)) {
            return new IdlInterfaceWriter(clz);
        }
        if (IDLEntity.class.isAssignableFrom(clz)) {
            return new ValuetypeWriter(clz);
        }
        if (clz == Serializable.class) {
            return SerializableWriter.instance;
        }
        if (RmiIdlUtil.isAbstractInterface(clz)) {
            return AbstractInterfaceWriter.instance;
        }
        if (Serializable.class.isAssignableFrom(clz)) {
            return new ValuetypeWriter(clz);
        }
        if (Externalizable.class.isAssignableFrom(clz)) {
            return ExternalizableWriter.instance;
        }
        if (clz == java.lang.Object.class) {
            return ObjectWriter.instance;
        }
        return new ValuetypeWriter(clz);
    }

    private static final class ValuetypeWriter
    implements CDRStreamWriter {
        private Class clz;

        ValuetypeWriter(Class clz) {
            this.clz = clz;
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_value((Serializable)obj, this.clz);
        }
    }

    private static final class AbstractInterfaceWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new AbstractInterfaceWriter();

        private AbstractInterfaceWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_abstract_interface(obj);
        }
    }

    private static final class IdlInterfaceWriter
    implements CDRStreamWriter {
        private Method writeMethod = null;

        IdlInterfaceWriter(Class clz) {
            String helperClassName = clz.getName() + "Helper";
            try {
                Class<?> helperClass = clz.getClassLoader().loadClass(helperClassName);
                Class[] paramTypes = new Class[]{org.omg.CORBA.portable.OutputStream.class, clz};
                this.writeMethod = helperClass.getMethod("write", paramTypes);
            }
            catch (ClassNotFoundException e) {
                throw IIOPLogger.ROOT_LOGGER.errorLoadingClass(helperClassName, e);
            }
            catch (NoSuchMethodException e) {
                throw IIOPLogger.ROOT_LOGGER.noWriteMethodInHelper(helperClassName, e);
            }
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            try {
                this.writeMethod.invoke(null, out, obj);
            }
            catch (IllegalAccessException e) {
                throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
            }
            catch (InvocationTargetException e) {
                throw IIOPLogger.ROOT_LOGGER.errorMarshaling(Object.class, e.getTargetException());
            }
        }
    }

    private static final class CorbaObjectWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new CorbaObjectWriter();

        private CorbaObjectWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_Object((Object)obj);
        }
    }

    private static final class ExternalizableWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new ExternalizableWriter();

        private ExternalizableWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            Util.writeAny((org.omg.CORBA.portable.OutputStream)out, (java.lang.Object)((Externalizable)obj));
        }
    }

    private static final class SerializableWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new SerializableWriter();

        private SerializableWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            Util.writeAny((org.omg.CORBA.portable.OutputStream)out, (java.lang.Object)((Serializable)obj));
        }
    }

    private static final class ObjectWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new ObjectWriter();

        private ObjectWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            Util.writeAny((org.omg.CORBA.portable.OutputStream)out, (java.lang.Object)obj);
        }
    }

    private static final class RemoteWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new RemoteWriter();

        private RemoteWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_Object((Object)obj);
        }
    }

    private static final class StringWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new StringWriter();

        private StringWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_value((Serializable)((java.lang.Object)((String)obj)), String.class);
        }
    }

    private static final class ShortWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new ShortWriter();

        private ShortWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_short(((Short)obj).shortValue());
        }
    }

    private static final class LongWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new LongWriter();

        private LongWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_longlong(((Long)obj).longValue());
        }
    }

    private static final class IntWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new IntWriter();

        private IntWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_long(((Integer)obj).intValue());
        }
    }

    private static final class FloatWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new FloatWriter();

        private FloatWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_float(((Float)obj).floatValue());
        }
    }

    private static final class DoubleWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new DoubleWriter();

        private DoubleWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_double(((Double)obj).doubleValue());
        }
    }

    private static final class CharWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new CharWriter();

        private CharWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_wchar(((Character)obj).charValue());
        }
    }

    private static final class ByteWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new ByteWriter();

        private ByteWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_octet(((Byte)obj).byteValue());
        }
    }

    private static final class BooleanWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new BooleanWriter();

        private BooleanWriter() {
        }

        @Override
        public void write(OutputStream out, java.lang.Object obj) {
            out.write_boolean(((Boolean)obj).booleanValue());
        }
    }

    private static final class ValuetypeReader
    implements CDRStreamReader {
        private Class clz;

        ValuetypeReader(Class clz) {
            this.clz = clz;
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return in.read_value(this.clz);
        }
    }

    private static final class AbstractInterfaceReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new AbstractInterfaceReader();

        private AbstractInterfaceReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return in.read_abstract_interface();
        }
    }

    private static final class IdlInterfaceReader
    implements CDRStreamReader {
        private static Class[] paramTypes = new Class[]{org.omg.CORBA.portable.InputStream.class};
        private Method readMethod = null;

        IdlInterfaceReader(Class clz) {
            String helperClassName = clz.getName() + "Helper";
            try {
                Class<?> helperClass = clz.getClassLoader().loadClass(helperClassName);
                this.readMethod = helperClass.getMethod("read", paramTypes);
            }
            catch (ClassNotFoundException e) {
                throw IIOPLogger.ROOT_LOGGER.errorLoadingClass(helperClassName, e);
            }
            catch (NoSuchMethodException e) {
                throw IIOPLogger.ROOT_LOGGER.noReadMethodInHelper(helperClassName, e);
            }
        }

        @Override
        public java.lang.Object read(InputStream in) {
            try {
                return this.readMethod.invoke(null, in);
            }
            catch (IllegalAccessException e) {
                throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
            }
            catch (InvocationTargetException e) {
                throw IIOPLogger.ROOT_LOGGER.errorUnmarshaling(Object.class, e.getTargetException());
            }
        }
    }

    private static final class CorbaObjectReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new CorbaObjectReader();

        private CorbaObjectReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return in.read_Object();
        }
    }

    private static final class ExternalizableReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new ExternalizableReader();

        private ExternalizableReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return (Externalizable)Util.readAny((org.omg.CORBA.portable.InputStream)in);
        }
    }

    private static final class SerializableReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new SerializableReader();

        private SerializableReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return (Serializable)Util.readAny((org.omg.CORBA.portable.InputStream)in);
        }
    }

    private static final class ObjectReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new ObjectReader();

        private ObjectReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return Util.readAny((org.omg.CORBA.portable.InputStream)in);
        }
    }

    private static final class RemoteReader
    implements CDRStreamReader {
        private Class clz;

        RemoteReader(Class clz) {
            this.clz = clz;
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return PortableRemoteObject.narrow((java.lang.Object)in.read_Object(), (Class)this.clz);
        }
    }

    private static final class StringReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new StringReader();

        private StringReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return in.read_value(String.class);
        }
    }

    private static final class ShortReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new ShortReader();

        private ShortReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return in.read_short();
        }
    }

    private static final class LongReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new LongReader();

        private LongReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return in.read_longlong();
        }
    }

    private static final class IntReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new IntReader();

        private IntReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return in.read_long();
        }
    }

    private static final class FloatReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new FloatReader();

        private FloatReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return Float.valueOf(in.read_float());
        }
    }

    private static final class DoubleReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new DoubleReader();

        private DoubleReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return in.read_double();
        }
    }

    private static final class CharReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new CharReader();

        private CharReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return Character.valueOf(in.read_wchar());
        }
    }

    private static final class ByteReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new ByteReader();

        private ByteReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return in.read_octet();
        }
    }

    private static final class BooleanReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new BooleanReader();

        private BooleanReader() {
        }

        @Override
        public java.lang.Object read(InputStream in) {
            return in.read_boolean();
        }
    }
}

