/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.weld.bean.builtin.BeanManagerProxy;

public final class BeanManagerService
implements Service<BeanManager> {
    public static final ServiceName NAME = ServiceNames.BEAN_MANAGER_SERVICE_NAME;
    private final Consumer<BeanManager> beanManagerConsumer;
    private final Supplier<WeldBootstrapService> weldContainerSupplier;
    private final String beanDeploymentArchiveId;
    private volatile BeanManagerProxy beanManager;

    public BeanManagerService(String beanDeploymentArchiveId, Consumer<BeanManager> beanManagerConsumer, Supplier<WeldBootstrapService> weldContainerSupplier) {
        this.beanDeploymentArchiveId = beanDeploymentArchiveId;
        this.beanManagerConsumer = beanManagerConsumer;
        this.weldContainerSupplier = weldContainerSupplier;
    }

    public void start(StartContext context) throws StartException {
        this.beanManager = new BeanManagerProxy(this.weldContainerSupplier.get().getBeanManager(this.beanDeploymentArchiveId));
        this.beanManagerConsumer.accept((BeanManager)this.beanManager);
    }

    public void stop(StopContext context) {
        this.beanManagerConsumer.accept(null);
        this.beanManager = null;
    }

    public BeanManager getValue() {
        return this.beanManager;
    }

    public static ServiceName serviceName(DeploymentUnit deploymentUnit) {
        return ServiceNames.beanManagerServiceName((DeploymentUnit)deploymentUnit);
    }
}

