/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.concurrent.TimeUnit;
import org.wildfly.extension.opentelemetry.OpenTelemetryConfig;
import org.wildfly.extension.opentelemetry.deployment.OpenTelemetryExtensionLogger;

public class OpenTelemetryHolder {
    public final OpenTelemetryConfig config;
    private static final String DEFAULT_SERVICE_NAME = "wildfly";
    private volatile OpenTelemetry openTelemetry;

    public OpenTelemetryHolder(OpenTelemetryConfig config) {
        this.config = config;
        this.openTelemetry = this.build(config);
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    private OpenTelemetry build(OpenTelemetryConfig config) {
        String serviceName = config.serviceName != null ? config.serviceName : DEFAULT_SERVICE_NAME;
        SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder().addSpanProcessor(this.getSpanProcessor(config)).setResource(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)serviceName)));
        if (config.sampler != null) {
            tracerProviderBuilder.setSampler(this.getSampler(config));
        }
        try {
            return OpenTelemetrySdk.builder().setTracerProvider(tracerProviderBuilder.build()).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).buildAndRegisterGlobal();
        }
        catch (IllegalStateException ex) {
            return GlobalOpenTelemetry.get();
        }
    }

    private SpanProcessor getSpanProcessor(OpenTelemetryConfig config) {
        SpanExporter spanExporter = this.getSpanExporter(config);
        switch (config.spanProcessor) {
            case "batch": {
                return BatchSpanProcessor.builder((SpanExporter)spanExporter).setScheduleDelay(config.batchDelay, TimeUnit.MILLISECONDS).setMaxQueueSize(config.maxQueueSize).setMaxExportBatchSize(config.maxExportBatchSize).setExporterTimeout(config.exportTimeout, TimeUnit.MILLISECONDS).build();
            }
            case "simple": {
                return SimpleSpanProcessor.create((SpanExporter)spanExporter);
            }
        }
        throw OpenTelemetryExtensionLogger.OTEL_LOGGER.unsupportedSpanProcessor(config.spanProcessor);
    }

    private Sampler getSampler(OpenTelemetryConfig config) {
        switch (config.sampler) {
            case "on": {
                return Sampler.alwaysOn();
            }
            case "off": {
                return Sampler.alwaysOff();
            }
            case "ratio": {
                return Sampler.traceIdRatioBased((double)config.ratio);
            }
        }
        throw OpenTelemetryExtensionLogger.OTEL_LOGGER.unsupportedSampler(config.sampler);
    }

    private SpanExporter getSpanExporter(OpenTelemetryConfig config) {
        switch (config.exporter) {
            case "jaeger": {
                return JaegerGrpcSpanExporter.builder().setEndpoint(config.endpoint).setTimeout(config.exportTimeout, TimeUnit.MILLISECONDS).build();
            }
            case "otlp": {
                return OtlpGrpcSpanExporter.builder().setEndpoint(config.endpoint).setTimeout(config.exportTimeout, TimeUnit.MILLISECONDS).build();
            }
        }
        throw OpenTelemetryExtensionLogger.OTEL_LOGGER.unsupportedExporter(config.exporter);
    }
}

