/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import java.util.HashSet;
import java.util.Map;
import java.util.OptionalDouble;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.wildfly.extension.metrics.Metric;
import org.wildfly.extension.metrics.MetricID;
import org.wildfly.extension.metrics.MetricMetadata;
import org.wildfly.extension.metrics.WildFlyMetricRegistry;

public class PrometheusExporter {
    private static final String LF = "\n";

    public String export(WildFlyMetricRegistry registry) {
        HashSet<String> alreadyExportedMetrics = new HashSet<String>();
        StringBuilder out = new StringBuilder();
        for (Map.Entry<MetricID, Metric> entry : registry.getMetrics().entrySet()) {
            MetricID metricID = entry.getKey();
            String metricName = metricID.getMetricName();
            MetricMetadata metadata = registry.getMetricMetadata().get(metricName);
            String prometheusMetricName = PrometheusExporter.toPrometheusMetricName(metricID, metadata);
            OptionalDouble metricValue = entry.getValue().getValue();
            if (!metricValue.isPresent()) continue;
            if (!alreadyExportedMetrics.contains(metricName)) {
                out.append("# HELP " + prometheusMetricName + " " + metadata.getDescription());
                out.append(LF);
                out.append("# TYPE " + prometheusMetricName + " " + (Object)((Object)metadata.getType()));
                out.append(LF);
                alreadyExportedMetrics.add(metricName);
            }
            double scaledValue = PrometheusExporter.scaleToBaseUnit(metricValue.getAsDouble(), metadata.getMeasurementUnit());
            if (metadata.getType() == MetricMetadata.Type.COUNTER && metadata.getMeasurementUnit() != MeasurementUnit.NONE) {
                prometheusMetricName = prometheusMetricName + "_" + metadata.getBaseMetricUnit();
            }
            out.append(prometheusMetricName + PrometheusExporter.getTagsAsAString(metricID) + " " + scaledValue);
            out.append(LF);
        }
        return out.toString();
    }

    private static double scaleToBaseUnit(double value, MeasurementUnit unit) {
        return value * MeasurementUnit.calculateOffset((MeasurementUnit)unit, (MeasurementUnit)unit.getBaseUnits());
    }

    private static String toPrometheusMetricName(MetricID metricID, MetricMetadata metadata) {
        String prometheusName = metricID.getMetricName();
        if (metadata.getType() == MetricMetadata.Type.COUNTER) {
            prometheusName = prometheusName + "_total";
        } else {
            String baseUnit = metadata.getBaseMetricUnit();
            if (!"none".equals(baseUnit)) {
                prometheusName = prometheusName + "_" + baseUnit;
            }
        }
        return prometheusName;
    }

    public static String getTagsAsAString(MetricID metricID) {
        MetricMetadata.MetricTag[] tags = metricID.getTags();
        if (tags.length == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder("{");
        for (int i = 0; i < tags.length; ++i) {
            if (i > 0) {
                out.append(",");
            }
            MetricMetadata.MetricTag tag = tags[i];
            out.append(tag.getKey() + "=\"" + tag.getValue() + "\"");
        }
        return out.append("}").toString();
    }
}

