/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.transform;

import java.util.Map;
import java.util.Set;
import org.jboss.as.clustering.controller.transform.SimpleRejectAttributeChecker;
import org.jboss.as.clustering.logging.ClusteringLogger;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.dmr.ModelNode;

public enum RejectNonSingletonListAttributeChecker implements RejectAttributeChecker
{
    INSTANCE;

    private final RejectAttributeChecker checker = new SimpleRejectAttributeChecker(new SimpleRejectAttributeChecker.Rejecter(){

        @Override
        public boolean reject(PathAddress address, String name, ModelNode value, ModelNode model, TransformationContext context) {
            return value.isDefined() && value.asList().size() > 1;
        }

        @Override
        public String getRejectedMessage(Set<String> attributes) {
            return ClusteringLogger.ROOT_LOGGER.rejectedMultipleValues(attributes);
        }
    });

    public boolean rejectOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
        return this.checker.rejectOperationParameter(address, attributeName, attributeValue, operation, context);
    }

    public boolean rejectResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
        return this.checker.rejectResourceAttribute(address, attributeName, attributeValue, context);
    }

    public String getRejectionLogMessageId() {
        return this.checker.getRejectionLogMessageId();
    }

    public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
        return this.checker.getRejectionLogMessage(attributes);
    }
}

