/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import javax.jms.IllegalStateException;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class ActiveMQRALogger_$logger
extends DelegatingBasicLogger
implements ActiveMQRALogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQRALogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ActiveMQRALogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void awaitingTopicQueueCreation(String destination) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.awaitingTopicQueueCreation$str(), (Object)destination);
    }

    protected String awaitingTopicQueueCreation$str() {
        return "AMQ151000: awaiting topic/queue creation {0}";
    }

    @Override
    public final void attemptingReconnect(ActiveMQActivationSpec spec) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.attemptingReconnect$str(), (Object)spec);
    }

    protected String attemptingReconnect$str() {
        return "AMQ151001: Attempting to reconnect {0}";
    }

    @Override
    public final void reconnected() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.reconnected$str(), new Object[0]);
    }

    protected String reconnected$str() {
        return "AMQ151002: Reconnected with broker";
    }

    @Override
    public final void raStopped() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.raStopped$str(), new Object[0]);
    }

    protected String raStopped$str() {
        return "AMQ151003: resource adaptor stopped";
    }

    @Override
    public final void instantiatingDestination(String destinationType, String destination) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.instantiatingDestination$str(), (Object)destinationType, (Object)destination);
    }

    protected String instantiatingDestination$str() {
        return "AMQ151004: Instantiating {0} \"{1}\" directly since UseJNDI=false.";
    }

    @Override
    public final void awaitingJMSServerCreation() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.awaitingJMSServerCreation$str(), new Object[0]);
    }

    protected String awaitingJMSServerCreation$str() {
        return "AMQ151005: awaiting server availability";
    }

    @Override
    public final void rebalancingConnections(String event) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.rebalancingConnections$str(), (Object)event);
    }

    protected String rebalancingConnections$str() {
        return "AMQ151006: Cluster topology change detected. Re-balancing connections on even {0}.";
    }

    @Override
    public final void resourceAdaptorStarted() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.resourceAdaptorStarted$str(), new Object[0]);
    }

    protected String resourceAdaptorStarted$str() {
        return "AMQ151007: Resource adaptor started";
    }

    @Override
    public final void problemResettingXASession(Throwable t) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.problemResettingXASession$str(), new Object[0]);
    }

    protected String problemResettingXASession$str() {
        return "AMQ152001: problem resetting xa session after failure";
    }

    @Override
    public final void unableToRollbackTX() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.unableToRollbackTX$str(), new Object[0]);
    }

    protected String unableToRollbackTX$str() {
        return "AMQ152002: Unable to roll local transaction back";
    }

    @Override
    public final void unableToResetSession(String spec, Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToResetSession$str(), (Object)spec);
    }

    protected String unableToResetSession$str() {
        return "AMQ152003: unable to reset session after failure, we will place the MDB Inflow now in setup mode for activation={0}";
    }

    @Override
    public final void handlingJMSFailure(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.handlingJMSFailure$str(), new Object[0]);
    }

    protected String handlingJMSFailure$str() {
        return "AMQ152004: Handling JMS exception failure";
    }

    @Override
    public final void failureInActivation(Throwable t, ActiveMQActivationSpec spec) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.failureInActivation$str(), (Object)spec);
    }

    protected String failureInActivation$str() {
        return "AMQ152005: Failure in broker activation {0}";
    }

    @Override
    public final void unableToCallAfterDelivery(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCallAfterDelivery$str(), new Object[0]);
    }

    protected String unableToCallAfterDelivery$str() {
        return "AMQ152006: Unable to call after delivery";
    }

    @Override
    public final void threadCouldNotFinish(String thread) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.threadCouldNotFinish$str(), (Object)thread);
    }

    protected String threadCouldNotFinish$str() {
        return "AMQ152007: Thread {0} could not be finished";
    }

    @Override
    public final void errorInterruptingHandler(String endpoint, String handler, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.WARN, cause, this.errorInterruptingHandler$str(), (Object)endpoint, (Object)handler);
    }

    protected String errorInterruptingHandler$str() {
        return "AMQ152008: Error interrupting handler on endpoint {0} handler = {1}";
    }

    @Override
    public final void unableToValidateProperties(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToValidateProperties$str(), new Object[0]);
    }

    protected String unableToValidateProperties$str() {
        return "AMQ152009: Unable to validate properties";
    }

    @Override
    public final void unableToClearTheTransaction(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToClearTheTransaction$str(), new Object[0]);
    }

    protected String unableToClearTheTransaction$str() {
        return "AMQ152010: Unable to clear the transaction";
    }

    @Override
    public final void unableToCloseFactory(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.unableToCloseFactory$str(), new Object[0]);
    }

    protected String unableToCloseFactory$str() {
        return "AMQ152011: Unable to close the factory";
    }

    @Override
    public final void errorCreatingReference(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorCreatingReference$str(), new Object[0]);
    }

    protected String errorCreatingReference$str() {
        return "AMQ154000: Error while creating object Reference.";
    }

    @Override
    public final void errorStoppingRA(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorStoppingRA$str(), new Object[0]);
    }

    protected String errorStoppingRA$str() {
        return "AMQ154001: Unable to stop resource adapter.";
    }

    @Override
    public final void errorReconnecting(Throwable t, ActiveMQActivationSpec spec) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorReconnecting$str(), (Object)spec);
    }

    protected String errorReconnecting$str() {
        return "AMQ154003: Unable to reconnect {0}";
    }

    @Override
    public final void errorDeliveringMessage(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorDeliveringMessage$str(), new Object[0]);
    }

    protected String errorDeliveringMessage$str() {
        return "AMQ154004: Failed to deliver message";
    }

    @Override
    public final void warnDifferentConnectionfactory() {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.warnDifferentConnectionfactory$str(), new Object[0]);
    }

    protected String warnDifferentConnectionfactory$str() {
        return "AMQ153001: using different ActiveMQRAConnectionFactory";
    }

    protected String canNotCreatedNonSharedSubscriber$str() {
        return "AMQ153002: Cannot create a subscriber on the durable subscription since it already has subscriber(s)";
    }

    @Override
    public final IllegalStateException canNotCreatedNonSharedSubscriber() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.canNotCreatedNonSharedSubscriber$str(), new Object[0]));
        ActiveMQRALogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void invalidAcknowledgementMode(String mode) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.invalidAcknowledgementMode$str(), (Object)mode);
    }

    protected String invalidAcknowledgementMode$str() {
        return "AMQ153003: Unsupported acknowledgement mode {0}";
    }

    @Override
    public final void invalidNumberOfMaxSession(int value, int defaultValue) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.invalidNumberOfMaxSession$str(), (Object)value, (Object)defaultValue);
    }

    protected String invalidNumberOfMaxSession$str() {
        return "AMQ153004: Invalid number of session (negative) {0}, defaulting to {1}.";
    }

    @Override
    public final void unableToRetrieveDestinationName(String destinationName, String name, String calculatedDestinationName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.unableToRetrieveDestinationName$str(), (Object)destinationName, (Object)name, (Object)calculatedDestinationName);
    }

    protected String unableToRetrieveDestinationName$str() {
        return "AMQ153005: Unable to retrieve \"{0}\" from JNDI. Creating a new \"{1}\" named \"{2}\" to be used by the MDB.";
    }
}

