/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.client.hotrod.counter.impl.BaseCounter;
import org.infinispan.client.hotrod.counter.impl.CounterOperationFactory;
import org.infinispan.client.hotrod.counter.impl.NotificationManager;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.SyncStrongCounter;

class StrongCounterImpl
extends BaseCounter
implements StrongCounter {
    private final SyncStrongCounter syncCounter = new Sync();

    StrongCounterImpl(String name, CounterConfiguration configuration, CounterOperationFactory operationFactory, NotificationManager notificationManager) {
        super(configuration, name, operationFactory, notificationManager);
    }

    public CompletableFuture<Long> getValue() {
        return this.factory.newGetValueOperation(this.name, this.useConsistentHash()).execute();
    }

    public CompletableFuture<Long> addAndGet(long delta) {
        return this.factory.newAddOperation(this.name, delta, this.useConsistentHash()).execute();
    }

    public CompletableFuture<Long> compareAndSwap(long expect, long update) {
        return this.factory.newCompareAndSwapOperation(this.name, expect, update, super.getConfiguration()).execute();
    }

    public SyncStrongCounter sync() {
        return this.syncCounter;
    }

    @Override
    boolean useConsistentHash() {
        return true;
    }

    private class Sync
    implements SyncStrongCounter {
        private Sync() {
        }

        public long addAndGet(long delta) {
            return Util.await(StrongCounterImpl.this.addAndGet(delta));
        }

        public void reset() {
            Util.await(StrongCounterImpl.this.reset());
        }

        public long getValue() {
            return Util.await(StrongCounterImpl.this.getValue());
        }

        public long compareAndSwap(long expect, long update) {
            return Util.await(StrongCounterImpl.this.compareAndSwap(expect, update));
        }

        public String getName() {
            return StrongCounterImpl.this.name;
        }

        public CounterConfiguration getConfiguration() {
            return StrongCounterImpl.this.configuration;
        }

        public void remove() {
            Util.await(StrongCounterImpl.this.remove());
        }
    }
}

