/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.KeyStoreException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String noRealmFoundInProperties$str() {
        return "ELY01006: No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line";
    }

    @Override
    public final RealmUnavailableException noRealmFoundInProperties() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.noRealmFoundInProperties$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void debugInfoJaasAuthenticationFailure(Principal principal, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.DEBUG, cause, this.debugInfoJaasAuthenticationFailure$str(), (Object)principal);
    }

    protected String debugInfoJaasAuthenticationFailure$str() {
        return "ELY01007: JAAS authentication failed for principal %s";
    }

    protected String failedToCreateLoginContext$str() {
        return "ELY01008: Failed to create login context";
    }

    @Override
    public final RealmUnavailableException failedToCreateLoginContext(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.failedToCreateLoginContext$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToInstantiateCustomHandler$str() {
        return "ELY01009: Failed to instantiate custom CallbackHandler";
    }

    @Override
    public final RealmUnavailableException failedToInstantiateCustomHandler(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.failedToInstantiateCustomHandler$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmFailedToOpen$str() {
        return "ELY01012: Filesystem-backed realm unexpectedly failed to open path \"%s\" for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmFailedToOpen(Path path, String finalName, IOException cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmFailedToOpen$str(), path, finalName), (Throwable)cause);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmFailedToRead$str() {
        return "ELY01013: Filesystem-backed realm unexpectedly failed to read path \"%s\" for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmFailedToRead(Path path, String finalName, Exception cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmFailedToRead$str(), path, finalName), (Throwable)cause);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmInvalidContent$str() {
        return "ELY01015: Filesystem-backed realm encountered invalid file content in path \"%s\" line %d for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmInvalidContent(Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmInvalidContent$str(), path, lineNumber, name));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmMissingAttribute$str() {
        return "ELY01016: Filesystem-backed realm encountered missing required attribute \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmMissingAttribute(String attribute, Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmMissingAttribute$str(), attribute, path, lineNumber, name));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmInvalidPasswordFormat$str() {
        return "ELY01017: Filesystem-backed realm encountered invalid password format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmInvalidPasswordFormat(String format, Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmInvalidPasswordFormat$str(), format, path, lineNumber, name));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmInvalidPasswordAlgorithm$str() {
        return "ELY01018: Filesystem-backed realm encountered invalid password algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmInvalidPasswordAlgorithm(String algorithm, Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmInvalidPasswordAlgorithm$str(), algorithm, path, lineNumber, name));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemUpdatedFailed$str() {
        return "ELY01020: Filesystem-backed realm failed to update identity \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemUpdatedFailed(String name, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemUpdatedFailed$str(), name), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmDeleteFailed$str() {
        return "ELY01021: Filesystem-backed realm failed to delete identity \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmDeleteFailed(String name, IOException e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmDeleteFailed$str(), name), (Throwable)e);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmNotFound$str() {
        return "ELY01022: Filesystem-backed realm failed to find identity \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmNotFound(String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmNotFound$str(), name));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmFailedToWrite$str() {
        return "ELY01023: Filesystem-backed realm failed to write to file \"%s\" for identity \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmFailedToWrite(Path tempPath, String name, Exception e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmFailedToWrite$str(), tempPath, name), (Throwable)e);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmAlreadyExists$str() {
        return "ELY01024: Filesystem-backed realm cannot create duplicate identity for identity \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmAlreadyExists(String name, Throwable e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmAlreadyExists$str(), name), e);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmCertificateReadError$str() {
        return "ELY01025: Filesystem-backed realm encountered invalid certificate format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmCertificateReadError(String format, Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmCertificateReadError$str(), format, path, lineNumber, name));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmUnsupportedKeyFormat$str() {
        return "ELY01026: Filesystem-backed realm encountered invalid key format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmUnsupportedKeyFormat(String format, Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmUnsupportedKeyFormat$str(), format, path, lineNumber, name));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmUnsupportedKeyAlgorithm$str() {
        return "ELY01027: Filesystem-backed realm encountered invalid key algorithm for format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmUnsupportedKeyAlgorithm(String format, Path path, int lineNumber, String name, Exception e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmUnsupportedKeyAlgorithm$str(), format, path, lineNumber, name), (Throwable)e);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidName$str() {
        return "ELY01064: Invalid identity name";
    }

    @Override
    public final IllegalArgumentException invalidName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidName$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fileSystemRealmInvalidOtpDefinition$str() {
        return "ELY01081: Filesystem-backed realm encountered invalid OTP definition in path \"%s\" line %d for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmInvalidOtpDefinition(Path path, int lineNumber, String name, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmInvalidOtpDefinition$str(), path, lineNumber, name), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmInvalidOtpAlgorithm$str() {
        return "ELY01082: Filesystem-backed realm encountered invalid OTP algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmInvalidOtpAlgorithm(String algorithm, Path path, int lineNumber, String name, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmInvalidOtpAlgorithm$str(), algorithm, path, lineNumber, name), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String decodingHashedPasswordFromPropertiesRealmFailed$str() {
        return "ELY01138: Decoding hashed password from users property file failed - should not be set as plain-text property file?";
    }

    @Override
    public final RealmUnavailableException decodingHashedPasswordFromPropertiesRealmFailed(Exception e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.decodingHashedPasswordFromPropertiesRealmFailed$str(), new Object[0]), (Throwable)e);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String realmCacheUnexpectedType$str() {
        return "ELY01145: Security realm [%s] must implement [%s]";
    }

    @Override
    public final IllegalArgumentException realmCacheUnexpectedType(SecurityRealm realm, Class<? extends CacheableSecurityRealm> expectedType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.realmCacheUnexpectedType$str(), realm, expectedType));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transformedPrincipalCannotBeNull$str() {
        return "ELY13000: Authorization principal cannot be null after transformation";
    }

    @Override
    public final IllegalStateException transformedPrincipalCannotBeNull() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.transformedPrincipalCannotBeNull$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToReadKeyStore$str() {
        return "ELY01154: Failed to read key store";
    }

    @Override
    public final RealmUnavailableException failedToReadKeyStore(KeyStoreException e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.failedToReadKeyStore$str(), new Object[0]), (Throwable)e);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidUnicodeSequence$str() {
        return "ELY11005: Invalid unicode endoding, offending sequence: %s.";
    }

    @Override
    public final IOException invalidUnicodeSequence(String s, NoSuchElementException nsee) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidUnicodeSequence$str(), s), nsee);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void realmFailover(RealmUnavailableException rue) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)rue, this.realmFailover$str(), new Object[0]);
    }

    protected String realmFailover$str() {
        return "ELY13001: Realm is failing over.";
    }

    protected String unableToHandleCallback$str() {
        return "ELY13002: %s does not handle a callback of type %s";
    }

    @Override
    public final UnsupportedCallbackException unableToHandleCallback(Callback callback, String callbackHandler, String callbackType) {
        UnsupportedCallbackException result = new UnsupportedCallbackException(callback, String.format(this.getLoggingLocale(), this.unableToHandleCallback$str(), callbackHandler, callbackType));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadJaasConfigFile$str() {
        return "ELY13003: Failed to load JAAS configuration file.";
    }

    @Override
    public final RealmUnavailableException failedToLoadJaasConfigFile() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.failedToLoadJaasConfigFile$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void debugInfoJaasLogoutFailure(Principal principal, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.DEBUG, cause, this.debugInfoJaasLogoutFailure$str(), (Object)principal);
    }

    protected String debugInfoJaasLogoutFailure$str() {
        return "ELY13004: JAAS logout failed for principal %s";
    }

    protected String fileSystemRealmDecryptionFailed$str() {
        return "ELY13005: Filesystem-backed realm unable to decrypt identity";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmDecryptionFailed(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmDecryptionFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmEncryptionFailed$str() {
        return "ELY13006: Filesystem-backed realm unable to encrypt identity";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmEncryptionFailed(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmEncryptionFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileSystemRealmIncompatibleIdentityVersion$str() {
        return "ELY13007: Filesystem-backed realm found an incompatible identity version. Requires at least version: %s";
    }

    @Override
    public final RealmUnavailableException fileSystemRealmIncompatibleIdentityVersion(String expectedVersion) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmIncompatibleIdentityVersion$str(), expectedVersion));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

