/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Bundler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@MBean(description="Implementation of Random Early Drop: messages are discarded when the bundler's queue in the transport nears exhaustion")
public class RED
extends Protocol {
    @Property(description="If false, all messages are passed down. Will be set to false if the bundler returns a queue size of -1")
    protected boolean enabled = true;
    @ManagedAttribute(description="The capacity of the queue (assumed to be constant)")
    protected int queue_capacity;
    @Property(description="The min threshold (percentage between 0 and 1.0) below which no message is dropped")
    protected double min_threshold = 0.5;
    protected long min;
    @Property(description="The max threshold (percentage between min_threshold and 1.0) above which all messages are dropped")
    protected double max_threshold = 1.0;
    protected long max;
    @ManagedAttribute(description="The average number of elements in the bundler's queue. Computed as o * (1 - 2^-wf) + c * (2^-wf) where o is the old average, c the current queue size amd wf the weight_factor")
    protected double avg_queue_size;
    @Property(description="The weight used to compute the average queue size. The higher the value is, the less the current queue size is taken into account. E.g. with 2, 25% of the current queue size and 75% of the old average is taken to compute the new average. In other words: with a high value, the average will take longer to reflect the current queueu size.")
    protected double weight_factor = 2.0;
    protected final LongAdder dropped_msgs = new LongAdder();
    protected final LongAdder total_msgs = new LongAdder();
    protected Bundler bundler;
    protected final Lock lock = new ReentrantLock();
    protected long span = this.max - this.min;
    protected double weight = Math.pow(2.0, -this.weight_factor);

    public boolean isEnabled() {
        return this.enabled;
    }

    public RED setEnabled(boolean e) {
        this.enabled = e;
        return this;
    }

    public double getMinThreshold() {
        return this.min_threshold;
    }

    @ManagedAttribute(description="The number of dropped messages")
    public long getDroppedMessages() {
        return this.dropped_msgs.sum();
    }

    @ManagedAttribute(description="Total number of messages processed")
    public long getTotalMessages() {
        return this.total_msgs.sum();
    }

    @ManagedAttribute(description="Percentage of all messages that were dropped")
    public double getDropRate() {
        return (double)this.dropped_msgs.sum() / (double)this.total_msgs.sum();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.bundler = this.getTransport().getBundler();
        boolean bl = this.enabled = this.bundler != null && this.bundler.getQueueSize() >= 0;
        if (this.enabled) {
            this.queue_capacity = this.getTransport().getBundlerCapacity();
            this.min = (long)((double)this.queue_capacity * RED.checkRange(this.min_threshold, 0.0, 1.0, "min_threshold"));
            this.max = (long)((double)this.queue_capacity * RED.checkRange(this.max_threshold, 0.0, 1.0, "max_threshold"));
            this.span = this.max - this.min;
            this.weight = Math.pow(2.0, -this.weight_factor);
        }
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.avg_queue_size = 0.0;
        this.dropped_msgs.reset();
        this.total_msgs.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Message msg) {
        if (this.enabled) {
            boolean drop;
            double avg;
            int current_queue_size = this.bundler.getQueueSize();
            this.lock.lock();
            try {
                avg = this.avg_queue_size = this.computeAverage(this.avg_queue_size, current_queue_size);
            }
            finally {
                this.lock.unlock();
            }
            this.total_msgs.increment();
            boolean bl = drop = !(avg <= (double)this.min) && (avg >= (double)this.max || this.drop(avg));
            if (drop) {
                this.dropped_msgs.increment();
                return null;
            }
        }
        return this.down_prot.down(msg);
    }

    public String toString() {
        return String.format("enabled=%b, queue capacity=%d, min=%d, max=%d, avg-queue-size=%.2f, total=%d dropped=%d (%d%%)", this.enabled, this.queue_capacity, this.min, this.max, this.avg_queue_size, this.total_msgs.sum(), this.dropped_msgs.sum(), (int)(this.getDropRate() * 100.0));
    }

    protected double computeAverage(double old_avg, int new_queue_size) {
        return old_avg * (1.0 - this.weight) + (double)new_queue_size * this.weight;
    }

    protected double computeDropProbability(double avg) {
        return Math.min(1.0, (avg - (double)this.min) / (double)this.span);
    }

    protected boolean drop(double avg) {
        double p = this.computeDropProbability(avg);
        return Util.tossWeightedCoin(p);
    }

    protected static double checkRange(double val, double min, double max, String name) {
        if (val < min || val > max) {
            throw new IllegalArgumentException(String.format("%s (%.2f) needs to be in range [%.2f..%.2f]", name, val, min, max));
        }
        return val;
    }
}

