/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.spi.PartitionWorker;

public class ThreadPartitionWorker
implements PartitionWorker {
    private BlockingQueue<Boolean> completedPartitionThreads;
    private BlockingQueue<Serializable> collectorDataQueue;

    public ThreadPartitionWorker(BlockingQueue<Boolean> completedPartitionThreads, BlockingQueue<Serializable> collectorDataQueue) {
        this.completedPartitionThreads = completedPartitionThreads;
        this.collectorDataQueue = collectorDataQueue;
    }

    @Override
    public void reportData(Serializable data, AbstractStepExecution partitionExecution) throws Exception {
        this.collectorDataQueue.put(data);
    }

    @Override
    public void partitionDone(AbstractStepExecution partitionExecution) throws Exception {
        if (this.completedPartitionThreads != null) {
            this.completedPartitionThreads.offer(Boolean.TRUE);
        }
        this.collectorDataQueue.put(partitionExecution);
    }
}

