/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.as.jpa.container.SFSBInjectedXPCs;
import org.jboss.as.jpa.messages.JpaLogger;

public class SFSBCallStack {
    private static final ThreadLocal<SFSBCallStackThreadData> CURRENT = new ThreadLocal<SFSBCallStackThreadData>(){

        @Override
        protected SFSBCallStackThreadData initialValue() {
            return new SFSBCallStackThreadData();
        }
    };

    public static int getSFSBCreationBeanNestingLevel() {
        return CURRENT.get().creationBeanNestingLevel;
    }

    public static void beginSfsbCreation() {
        SFSBCallStackThreadData data = CURRENT.get();
        int no = data.creationBeanNestingLevel;
        if (no == 0) {
            data.creationTimeXPCRegistration = new HashMap();
            data.creationTimeInjectedXPCs = new SFSBInjectedXPCs(data.creationTimeInjectedXPCs, null);
        } else {
            SFSBInjectedXPCs parent = data.creationTimeInjectedXPCs;
            data.creationTimeInjectedXPCs = new SFSBInjectedXPCs(parent, parent.getTopLevel());
        }
        data.creationBeanNestingLevel++;
    }

    public static void endSfsbCreation() {
        SFSBCallStackThreadData data = CURRENT.get();
        int no = data.creationBeanNestingLevel;
        data.creationBeanNestingLevel = --no;
        if (no == 0) {
            data.creationTimeXPCRegistration = null;
            data.creationTimeInjectedXPCs = null;
        } else {
            data.creationTimeInjectedXPCs = data.creationTimeInjectedXPCs.getParent();
        }
    }

    static SFSBInjectedXPCs getSFSBCreationTimeInjectedXPCs(String puScopedName) {
        SFSBInjectedXPCs result = CURRENT.get().creationTimeInjectedXPCs;
        if (result == null) {
            throw JpaLogger.ROOT_LOGGER.xpcOnlyFromSFSB(puScopedName);
        }
        return result;
    }

    public static ArrayList<Map<String, ExtendedEntityManager>> currentSFSBCallStack() {
        return CURRENT.get().invocationStack;
    }

    public static Map<String, ExtendedEntityManager> currentSFSBCallStackInvocation() {
        ArrayList stack = CURRENT.get().invocationStack;
        if (stack != null && !stack.isEmpty()) {
            return (Map)stack.get(stack.size() - 1);
        }
        return null;
    }

    public static void pushCall(Map<String, ExtendedEntityManager> entityManagers) {
        SFSBCallStack.currentSFSBCallStack().add(entityManagers);
        if (entityManagers != null) {
            for (ExtendedEntityManager extendedEntityManager : entityManagers.values()) {
                extendedEntityManager.internalAssociateWithJtaTx();
            }
        }
    }

    public static Map<String, ExtendedEntityManager> popCall() {
        ArrayList<Map<String, ExtendedEntityManager>> stack = SFSBCallStack.currentSFSBCallStack();
        Map<String, ExtendedEntityManager> result = stack.remove(stack.size() - 1);
        stack.trimToSize();
        return result;
    }

    static Map<String, ExtendedEntityManager> getCurrentCall() {
        ArrayList<Map<String, ExtendedEntityManager>> stack = SFSBCallStack.currentSFSBCallStack();
        Map<String, ExtendedEntityManager> result = null;
        if (stack != null) {
            result = stack.get(stack.size() - 1);
        }
        return result;
    }

    private static class SFSBCallStackThreadData {
        private ArrayList<Map<String, ExtendedEntityManager>> invocationStack = new ArrayList();
        private Map<String, ExtendedEntityManager> creationTimeXPCRegistration = null;
        private SFSBInjectedXPCs creationTimeInjectedXPCs;
        private int creationBeanNestingLevel = 0;

        private SFSBCallStackThreadData() {
        }
    }
}

