/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.internal;

import com.arjuna.wst.BusinessAgreementWithParticipantCompletionParticipant;
import com.arjuna.wst.FaultedException;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.ConfirmCompletedParticipant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.narayana.compensations.api.CompensationHandler;
import org.jboss.narayana.compensations.api.ConfirmationHandler;
import org.jboss.narayana.compensations.api.TransactionLoggedHandler;
import org.jboss.narayana.compensations.internal.CompensationContext;

public class ParticipantImpl
implements BusinessAgreementWithParticipantCompletionParticipant,
ConfirmCompletedParticipant {
    private static final Map<Object, AtomicInteger> PARTICIPANT_COUNTERS = new HashMap<Object, AtomicInteger>();
    private CompensationHandler compensationHandler;
    private ConfirmationHandler confirmationHandler;
    private TransactionLoggedHandler transactionLoggedHandler;
    private ClassLoader applicationClassloader;
    private Object currentTX;

    public ParticipantImpl(CompensationHandler compensationHandler, ConfirmationHandler confirmationHandler, TransactionLoggedHandler transactionLoggedHandler, Object currentTX) {
        this.compensationHandler = compensationHandler;
        this.confirmationHandler = confirmationHandler;
        this.transactionLoggedHandler = transactionLoggedHandler;
        this.currentTX = currentTX;
        this.applicationClassloader = Thread.currentThread().getContextClassLoader();
        this.incrementParticipantsCounter();
    }

    public void confirmCompleted(boolean confirmed) {
        if (this.transactionLoggedHandler != null) {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.applicationClassloader);
            this.transactionLoggedHandler.transactionLogged(confirmed);
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    public void close() throws WrongStateException, SystemException {
        if (this.confirmationHandler != null) {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.applicationClassloader);
            CompensationContext.setTxContextToExtend(this.currentTX);
            this.confirmationHandler.confirm();
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
        this.decrementParticipantsCounter();
    }

    public void cancel() throws FaultedException, WrongStateException, SystemException {
    }

    public void compensate() throws FaultedException, WrongStateException, SystemException {
        try {
            if (this.compensationHandler != null) {
                ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.applicationClassloader);
                CompensationContext.setTxContextToExtend(this.currentTX);
                this.compensationHandler.compensate();
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.decrementParticipantsCounter();
    }

    public String status() throws SystemException {
        return null;
    }

    public void unknown() throws SystemException {
    }

    public void error() throws SystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementParticipantsCounter() {
        Map<Object, AtomicInteger> map = PARTICIPANT_COUNTERS;
        synchronized (map) {
            AtomicInteger counter = PARTICIPANT_COUNTERS.get(this.currentTX);
            if (counter == null) {
                PARTICIPANT_COUNTERS.put(this.currentTX, new AtomicInteger(1));
            } else {
                counter.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementParticipantsCounter() {
        Map<Object, AtomicInteger> map = PARTICIPANT_COUNTERS;
        synchronized (map) {
            AtomicInteger counter = PARTICIPANT_COUNTERS.get(this.currentTX);
            if (counter == null || counter.decrementAndGet() > 0) {
                return;
            }
            PARTICIPANT_COUNTERS.remove(this.currentTX);
        }
        CompensationContext.close(this.currentTX);
    }
}

