/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning.irac;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.irac.IracUpdateVersionCommand;
import org.infinispan.commons.util.Version;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.ScopedPersistentStateImpl;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteNamedCache;

@Scope(value=Scopes.NAMED_CACHE)
public class DefaultIracVersionGenerator
implements IracVersionGenerator {
    private static final Log log = LogFactory.getLog(DefaultIracVersionGenerator.class);
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("(\\d+)_(.*)$");
    private static final AtomicIntegerFieldUpdater<DefaultIracVersionGenerator> TOPOLOGY_UPDATED = AtomicIntegerFieldUpdater.newUpdater(DefaultIracVersionGenerator.class, "topologyId");
    private final Map<Integer, IracEntryVersion> segmentVersion;
    private final BiFunction<Integer, IracEntryVersion, IracEntryVersion> incrementAndGet = this::incrementAndGet;
    private final Function<Integer, IracEntryVersion> createFunction = segment -> this.newVersion();
    @Inject
    RpcManager rpcManager;
    @Inject
    GlobalStateManager globalStateManager;
    @Inject
    CommandsFactory commandsFactory;
    private ByteString localSite;
    private volatile int topologyId = 1;

    public DefaultIracVersionGenerator(int numberOfSegments) {
        this.segmentVersion = new ConcurrentHashMap<Integer, IracEntryVersion>(numberOfSegments);
    }

    @Start
    public void start() {
        this.rpcManager.getTransport().checkCrossSiteAvailable();
        this.localSite = XSiteNamedCache.cachedByteString(this.rpcManager.getTransport().localSiteName());
        this.globalStateManager.readScopedState(this.scope()).ifPresent(this::loadState);
    }

    @Stop
    public void stop() {
        this.globalStateManager.writeScopedState(this.writeState());
    }

    @Override
    public IracMetadata generateNewMetadata(int segment) {
        return new IracMetadata(this.localSite, this.segmentVersion.compute(segment, this.incrementAndGet));
    }

    @Override
    public IracMetadata generateMetadataWithCurrentVersion(int segment) {
        return new IracMetadata(this.localSite, this.segmentVersion.computeIfAbsent(segment, this.createFunction));
    }

    @Override
    public IracMetadata generateNewMetadata(int segment, IracEntryVersion versionSeen) {
        if (versionSeen == null) {
            return this.generateNewMetadata(segment);
        }
        int vTopology = versionSeen.getTopology(this.localSite);
        if (vTopology > this.topologyId) {
            this.updateTopology(vTopology);
        }
        IracEntryVersion version = this.segmentVersion.compute(segment, (s, currentVersion) -> currentVersion == null ? versionSeen.increment(this.localSite, this.topologyId) : currentVersion.merge(versionSeen).increment(this.localSite, this.topologyId));
        return new IracMetadata(this.localSite, version);
    }

    @Override
    public void updateVersion(int segment, IracEntryVersion remoteVersion) {
        if (remoteVersion == null) {
            return;
        }
        this.segmentVersion.merge(segment, remoteVersion, IracEntryVersion::merge);
        this.updateTopology(remoteVersion.getTopology(this.localSite));
    }

    @Override
    public void onTopologyChange(CacheTopology newTopology) {
        TOPOLOGY_UPDATED.incrementAndGet(this);
        if (newTopology.getPhase().isRebalance()) {
            IracUpdateVersionCommand cmd = this.commandsFactory.buildIracUpdateVersionCommand(this.peek());
            this.rpcManager.sendToAll(cmd, DeliverOrder.NONE);
        }
    }

    public Map<Integer, IracEntryVersion> peek() {
        return new HashMap<Integer, IracEntryVersion>(this.segmentVersion);
    }

    private void updateTopology(int newTopology) {
        int currentTopology = this.topologyId;
        while (newTopology > currentTopology && !TOPOLOGY_UPDATED.compareAndSet(this, currentTopology, newTopology)) {
            currentTopology = this.topologyId;
        }
    }

    private IracEntryVersion newVersion() {
        return IracEntryVersion.newVersion(this.localSite, TopologyIracVersion.newVersion(this.topologyId));
    }

    private IracEntryVersion incrementAndGet(int segment, IracEntryVersion currentVersion) {
        return currentVersion == null ? this.newVersion() : currentVersion.increment(this.localSite, this.topologyId);
    }

    private String scope() {
        return "___irac_version_" + this.commandsFactory.getCacheName();
    }

    private void loadState(ScopedPersistentState state) {
        assert (Version.getVersion().equals(state.getProperty("@version")));
        state.forEach((segmentAndSite, versionString) -> {
            Matcher result = PROPERTY_PATTERN.matcher((CharSequence)segmentAndSite);
            if (!result.find()) {
                return;
            }
            int segment = Integer.parseInt(result.group(1));
            String site = result.group(2);
            TopologyIracVersion v = TopologyIracVersion.fromString(versionString);
            if (v == null) {
                return;
            }
            IracEntryVersion partialVersion = IracEntryVersion.newVersion(XSiteNamedCache.cachedByteString(site), v);
            this.segmentVersion.compute(segment, (seg, version) -> version == null ? partialVersion : version.merge(partialVersion));
        });
        if (log.isTraceEnabled()) {
            log.tracef("Read state (%s entries): %s", this.segmentVersion.size(), this.segmentVersion);
        }
    }

    private ScopedPersistentState writeState() {
        if (log.isTraceEnabled()) {
            log.tracef("Write state (%s entries): %s", this.segmentVersion.size(), this.segmentVersion);
        }
        ScopedPersistentStateImpl state = new ScopedPersistentStateImpl(this.scope());
        state.setProperty("@version", Version.getVersion());
        this.segmentVersion.forEach((segment, version) -> {
            String prefix = segment + "_";
            version.forEach((site, v) -> state.setProperty(prefix + site, v.toString()));
        });
        return state;
    }
}

