/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.policies;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.activemq.artemis.core.server.balancing.policies.AbstractPolicy;
import org.apache.activemq.artemis.core.server.balancing.policies.ConsistentHashPolicy;
import org.apache.activemq.artemis.core.server.balancing.policies.FirstElementPolicy;
import org.apache.activemq.artemis.core.server.balancing.policies.LeastConnectionsPolicy;
import org.apache.activemq.artemis.core.server.balancing.policies.PolicyFactory;
import org.apache.activemq.artemis.core.server.balancing.policies.RoundRobinPolicy;

public class DefaultPolicyFactory
extends PolicyFactory {
    private static final Map<String, Supplier<AbstractPolicy>> supportedPolicies = new HashMap<String, Supplier<AbstractPolicy>>();

    @Override
    public String[] getSupportedPolicies() {
        return supportedPolicies.keySet().toArray(new String[supportedPolicies.size()]);
    }

    @Override
    public AbstractPolicy createPolicy(String policyName) {
        Supplier<AbstractPolicy> policySupplier = supportedPolicies.get(policyName);
        if (policySupplier == null) {
            throw new IllegalArgumentException("Policy not supported: " + policyName);
        }
        return policySupplier.get();
    }

    static {
        supportedPolicies.put("CONSISTENT_HASH", () -> new ConsistentHashPolicy());
        supportedPolicies.put("FIRST_ELEMENT", () -> new FirstElementPolicy());
        supportedPolicies.put("LEAST_CONNECTIONS", () -> new LeastConnectionsPolicy());
        supportedPolicies.put("ROUND_ROBIN", () -> new RoundRobinPolicy());
    }
}

