/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.LocalOutboundConnectionAdd;
import org.jboss.as.remoting.LocalOutboundConnectionResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

class LocalOutboundConnectionWriteHandler
extends AbstractWriteAttributeHandler<Boolean> {
    static final LocalOutboundConnectionWriteHandler INSTANCE = new LocalOutboundConnectionWriteHandler();

    private LocalOutboundConnectionWriteHandler() {
        super(new AttributeDefinition[]{LocalOutboundConnectionResourceDefinition.OUTBOUND_SOCKET_BINDING_REF});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
        boolean handback = this.applyModelToRuntime(context, operation);
        handbackHolder.setHandback((Object)handback);
        return handback;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
        if (handback != null && !handback.booleanValue()) {
            ModelNode restored = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            restored.get(attributeName).set(valueToRestore);
            this.applyModelToRuntime(context, restored);
        }
    }

    private boolean applyModelToRuntime(OperationContext context, ModelNode fullModel) throws OperationFailedException {
        boolean reloadRequired = false;
        String connectionName = context.getCurrentAddressValue();
        ServiceName serviceName = LocalOutboundConnectionResourceDefinition.OUTBOUND_CONNECTION_CAPABILITY.getCapabilityServiceName(new String[]{connectionName});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController sc = registry.getService(serviceName);
        if (sc != null && sc.getState() == ServiceController.State.UP) {
            reloadRequired = true;
        } else {
            context.removeService(serviceName);
            LocalOutboundConnectionAdd.INSTANCE.installRuntimeService(context, fullModel);
        }
        return reloadRequired;
    }
}

