/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.jbossts;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.recovery.ValidatingManagedConnectionFactoryRecoveryPlugin;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.jca.core.spi.security.SubjectFactory;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.XAResourceStatistics;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper;
import org.jboss.jca.core.tx.jbossts.SecurityActions;
import org.jboss.logging.Logger;

public class XAResourceRecoveryImpl
implements XAResourceRecovery,
org.jboss.tm.XAResourceRecovery {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)XAResourceRecoveryImpl.class.getName());
    private final TransactionIntegration ti;
    private final ManagedConnectionFactory mcf;
    private final Boolean padXid;
    private final Boolean isSameRMOverrideValue;
    private final Boolean wrapXAResource;
    private final String recoverUserName;
    private final String recoverPassword;
    private final String recoverSecurityDomain;
    private final SubjectFactory subjectFactory;
    private final RecoveryPlugin plugin;
    private final XAResourceStatistics xastat;
    private ManagedConnection recoverMC;
    private String jndiName;

    public XAResourceRecoveryImpl(TransactionIntegration ti, ManagedConnectionFactory mcf, Boolean padXid, Boolean isSameRMOverrideValue, Boolean wrapXAResource, String recoverUserName, String recoverPassword, String recoverSecurityDomain, SubjectFactory subjectFactory, RecoveryPlugin plugin, XAResourceStatistics xastat) {
        if (ti == null) {
            throw new IllegalArgumentException("TransactionIntegration is null");
        }
        if (mcf == null) {
            throw new IllegalArgumentException("MCF is null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin is null");
        }
        this.ti = ti;
        this.mcf = mcf;
        this.padXid = padXid;
        this.isSameRMOverrideValue = isSameRMOverrideValue;
        this.wrapXAResource = wrapXAResource;
        this.recoverUserName = recoverUserName;
        this.recoverPassword = recoverPassword;
        this.recoverSecurityDomain = recoverSecurityDomain;
        this.subjectFactory = subjectFactory;
        this.plugin = plugin instanceof ValidatingManagedConnectionFactoryRecoveryPlugin && mcf instanceof ValidatingManagedConnectionFactory ? null : plugin;
        this.xastat = xastat;
        this.recoverMC = null;
        this.jndiName = null;
    }

    public void initialize() throws Exception {
    }

    public void shutdown() throws Exception {
        if (this.recoverMC != null) {
            this.close(this.recoverMC);
        }
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource[] getXAResources() {
        try {
            Subject subject = this.getSubject();
            if (subject != null) {
                ManagedConnection mc = this.open(subject);
                XAResource xaResource = null;
                Object connection = null;
                try {
                    connection = this.openConnection(mc, subject);
                    xaResource = mc.getXAResource();
                }
                catch (ResourceException reconnect) {
                    this.closeConnection(connection);
                    connection = null;
                    this.close(mc);
                    mc = this.open(subject);
                    xaResource = mc.getXAResource();
                }
                finally {
                    boolean forceDestroy = this.closeConnection(connection);
                    connection = null;
                    if (forceDestroy) {
                        this.close(mc);
                        mc = this.open(subject);
                        xaResource = mc.getXAResource();
                    }
                }
                if (this.wrapXAResource.booleanValue() && !(xaResource instanceof XAResourceWrapper)) {
                    String eisProductName = null;
                    String eisProductVersion = null;
                    try {
                        if (mc.getMetaData() != null) {
                            eisProductName = mc.getMetaData().getEISProductName();
                            eisProductVersion = mc.getMetaData().getEISProductVersion();
                        }
                    }
                    catch (ResourceException resourceException) {
                        // empty catch block
                    }
                    if (eisProductName == null) {
                        eisProductName = this.jndiName;
                    }
                    if (eisProductVersion == null) {
                        eisProductVersion = this.jndiName;
                    }
                    xaResource = this.ti.createXAResourceWrapper(xaResource, this.padXid.booleanValue(), this.isSameRMOverrideValue, eisProductName, eisProductVersion, this.jndiName, false, this.xastat);
                }
                log.debugf("Recovery XAResource=%s for %s", xaResource, this.jndiName);
                return new XAResource[]{xaResource};
            }
            log.nullSubjectCrashRecovery(this.jndiName);
        }
        catch (ResourceException re) {
            log.exceptionDuringCrashRecovery(this.jndiName, re.getMessage(), re);
        }
        return new XAResource[0];
    }

    private Subject getSubject() {
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                if (XAResourceRecoveryImpl.this.recoverUserName != null && XAResourceRecoveryImpl.this.recoverPassword != null) {
                    log.debugf("Recovery user name=%s", XAResourceRecoveryImpl.this.recoverUserName);
                    Subject subject = SecurityActions.createSubject(XAResourceRecoveryImpl.this.recoverUserName, XAResourceRecoveryImpl.this.recoverPassword, XAResourceRecoveryImpl.this.mcf);
                    log.debugf("Recovery Subject=%s", subject);
                    return subject;
                }
                try {
                    String domain = XAResourceRecoveryImpl.this.recoverSecurityDomain;
                    if (domain != null && XAResourceRecoveryImpl.this.subjectFactory != null) {
                        Subject subject = SecurityActions.createSubject(XAResourceRecoveryImpl.this.subjectFactory, domain);
                        Set<PasswordCredential> pcs = SecurityActions.getPasswordCredentials(subject);
                        if (pcs.size() > 0) {
                            for (PasswordCredential pc : pcs) {
                                pc.setManagedConnectionFactory(XAResourceRecoveryImpl.this.mcf);
                            }
                        }
                        log.debugf("Recovery Subject=%s", subject);
                        return subject;
                    }
                    log.noCrashRecoverySecurityDomain(XAResourceRecoveryImpl.this.jndiName);
                }
                catch (Throwable t) {
                    log.exceptionDuringCrashRecoverySubject(XAResourceRecoveryImpl.this.jndiName, t.getMessage(), t);
                }
                return null;
            }
        });
    }

    private ManagedConnection open(Subject s) throws ResourceException {
        log.debugf("Open managed connection (%s)", s);
        if (this.recoverMC == null) {
            this.recoverMC = this.mcf.createManagedConnection(s, null);
        }
        if (this.plugin == null) {
            try {
                ValidatingManagedConnectionFactory vmcf = (ValidatingManagedConnectionFactory)this.mcf;
                HashSet<ManagedConnection> connectionSet = new HashSet<ManagedConnection>(1);
                connectionSet.add(this.recoverMC);
                Set invalid = vmcf.getInvalidConnections(connectionSet);
                if (invalid != null && invalid.size() > 0) {
                    log.debugf("Invalid managed connection: %s", this.recoverMC);
                    this.close(this.recoverMC);
                    this.recoverMC = this.mcf.createManagedConnection(s, null);
                }
            }
            catch (ResourceException re) {
                log.debugf("Exception during invalid check", (Object)re);
                this.close(this.recoverMC);
                this.recoverMC = this.mcf.createManagedConnection(s, null);
            }
        }
        return this.recoverMC;
    }

    private void close(ManagedConnection mc) {
        log.debugf("Closing managed connection for recovery (%s)", mc);
        if (mc != null) {
            try {
                mc.cleanup();
            }
            catch (ResourceException ire) {
                log.debugf("Error during recovery cleanup", (Object)ire);
            }
        }
        if (mc != null) {
            try {
                mc.destroy();
            }
            catch (ResourceException ire) {
                log.debugf("Error during recovery destroy", (Object)ire);
            }
        }
        this.recoverMC = null;
    }

    private Object openConnection(ManagedConnection mc, Subject s) throws ResourceException {
        if (this.plugin == null) {
            return null;
        }
        log.debugf("Open connection (%s, %s)", mc, s);
        return mc.getConnection(s, null);
    }

    private boolean closeConnection(Object c) {
        if (this.plugin == null) {
            return false;
        }
        log.debugf("Closing connection for recovery check (%s)", c);
        boolean forceClose = false;
        if (c != null) {
            try {
                forceClose = !this.plugin.isValid(c);
            }
            catch (ResourceException re) {
                log.debugf("Error during recovery plugin isValid()", (Object)re);
                forceClose = true;
            }
            try {
                this.plugin.close(c);
            }
            catch (ResourceException re) {
                log.debugf("Error during recovery plugin close()", (Object)re);
                forceClose = true;
            }
        }
        log.debugf("Force close=%s", forceClose);
        return forceClose;
    }
}

