/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.cache.session.SimpleImmutableSession;
import org.wildfly.clustering.web.cache.session.ValidSession;
import org.wildfly.clustering.web.hotrod.logging.Logger;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerConfiguration;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.common.function.Functions;

public class HotRodSessionManager<SC, MV, AV, LC>
implements SessionManager<LC, TransactionBatch> {
    private final Registrar<SessionExpirationListener> expirationRegistrar;
    private final SessionExpirationListener expirationListener;
    private final SessionFactory<SC, MV, AV, LC> factory;
    private final Supplier<String> identifierFactory;
    private final SC context;
    private final Batcher<TransactionBatch> batcher;
    private final Duration stopTimeout;
    private final Consumer<ImmutableSession> closeTask = Functions.discardingConsumer();
    private volatile Duration defaultMaxInactiveInterval = Duration.ofMinutes(30L);
    private volatile Registration expirationRegistration;

    public HotRodSessionManager(SessionFactory<SC, MV, AV, LC> factory, HotRodSessionManagerConfiguration<SC> configuration) {
        this.factory = factory;
        this.expirationRegistrar = configuration.getExpirationRegistrar();
        this.expirationListener = configuration.getExpirationListener();
        this.context = configuration.getServletContext();
        this.identifierFactory = configuration.getIdentifierFactory();
        this.batcher = configuration.getBatcher();
        this.stopTimeout = configuration.getStopTimeout();
    }

    public void start() {
        this.expirationRegistration = this.expirationRegistrar.register((Object)this.expirationListener);
    }

    public void stop() {
        this.expirationRegistration.close();
    }

    public Duration getStopTimeout() {
        return this.stopTimeout;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public Duration getDefaultMaxInactiveInterval() {
        return this.defaultMaxInactiveInterval;
    }

    public void setDefaultMaxInactiveInterval(Duration duration) {
        this.defaultMaxInactiveInterval = duration;
    }

    public Supplier<String> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Session<LC> findSession(String id) {
        Map.Entry entry = (Map.Entry)this.factory.findValue((Object)id);
        if (entry == null) {
            Logger.ROOT_LOGGER.tracef("Session %s not found", id);
            return null;
        }
        ImmutableSession session = this.factory.createImmutableSession(id, entry);
        if (session.getMetaData().isExpired()) {
            Logger.ROOT_LOGGER.tracef("Session %s was found, but has expired", id);
            this.expirationListener.sessionExpired(session);
            this.factory.remove((Object)id);
            return null;
        }
        return new ValidSession(this.factory.createSession(id, entry, this.context), this.closeTask);
    }

    public Session<LC> createSession(String id) {
        Map.Entry entry = (Map.Entry)this.factory.createValue((Object)id, null);
        if (entry == null) {
            return null;
        }
        Session session = this.factory.createSession(id, entry, this.context);
        session.getMetaData().setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        return new ValidSession(session, this.closeTask);
    }

    public ImmutableSession readSession(String id) {
        Map.Entry entry = (Map.Entry)this.factory.findValue((Object)id);
        return entry != null ? new SimpleImmutableSession(this.factory.createImmutableSession(id, entry)) : null;
    }

    public Set<String> getActiveSessions() {
        return Collections.emptySet();
    }

    public Set<String> getLocalSessions() {
        return Collections.emptySet();
    }

    public long getActiveSessionCount() {
        return this.getActiveSessions().size();
    }
}

