/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.providers.AbstractMediator;
import io.smallrye.reactive.messaging.providers.ProcessorMediator;
import io.smallrye.reactive.messaging.providers.PublisherMediator;
import io.smallrye.reactive.messaging.providers.StreamTransformerMediator;
import io.smallrye.reactive.messaging.providers.SubscriberMediator;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class MediatorFactory {
    public AbstractMediator create(MediatorConfiguration configuration) {
        switch (configuration.shape()) {
            case PROCESSOR: {
                return new ProcessorMediator(configuration);
            }
            case SUBSCRIBER: {
                return new SubscriberMediator(configuration);
            }
            case PUBLISHER: {
                return new PublisherMediator(configuration);
            }
            case STREAM_TRANSFORMER: {
                return new StreamTransformerMediator(configuration);
            }
        }
        throw ProviderExceptions.ex.illegalArgumentForUnsupportedShape(configuration.shape(), configuration.methodAsString());
    }
}

