/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.remoting.transport.Address;

public class RebalancePhaseConfirmCommand
extends AbstractCacheControlCommand {
    public static final byte COMMAND_ID = 87;
    private String cacheName;
    private Throwable throwable;
    private int topologyId;
    private int viewId;

    public RebalancePhaseConfirmCommand() {
        super((byte)87);
    }

    public RebalancePhaseConfirmCommand(String cacheName, Address origin, Throwable throwable, int topologyId, int viewId) {
        super((byte)87, origin);
        this.cacheName = cacheName;
        this.throwable = throwable;
        this.topologyId = topologyId;
        this.viewId = viewId;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        return gcr.getClusterTopologyManager().handleRebalancePhaseConfirm(this.cacheName, this.origin, this.topologyId, this.throwable, this.viewId);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString((String)this.cacheName, (ObjectOutput)output);
        output.writeObject(this.throwable);
        output.writeInt(this.topologyId);
        output.writeInt(this.viewId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString((ObjectInput)input);
        this.throwable = (Throwable)input.readObject();
        this.topologyId = input.readInt();
        this.viewId = input.readInt();
    }

    public String toString() {
        return "ConfirmRebalancePhaseCommand{cacheName='" + this.cacheName + '\'' + ", origin=" + this.origin + ", throwable=" + this.throwable + ", topologyId=" + this.topologyId + ", viewId=" + this.viewId + '}';
    }
}

