/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;

public class ModelNodeUtil {
    private static ConnectorLogger ROOT_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector");

    public static Long getLongIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key) throws OperationFailedException {
        ModelNode resolvedNode = key.resolveModelAttribute(context, dataSourceNode);
        return resolvedNode.isDefined() ? Long.valueOf(resolvedNode.asLong()) : null;
    }

    public static Integer getIntIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key) throws OperationFailedException {
        ModelNode resolvedNode = key.resolveModelAttribute(context, dataSourceNode);
        return resolvedNode.isDefined() ? Integer.valueOf(resolvedNode.asInt()) : null;
    }

    public static Boolean getBooleanIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key) throws OperationFailedException {
        ModelNode resolvedNode = key.resolveModelAttribute(context, dataSourceNode);
        return resolvedNode.isDefined() ? Boolean.valueOf(resolvedNode.asBoolean()) : null;
    }

    public static String getResolvedStringIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key) throws OperationFailedException {
        String resolvedString;
        ModelNode resolvedNode = key.resolveModelAttribute(context, dataSourceNode);
        String string = resolvedString = resolvedNode.isDefined() ? resolvedNode.asString() : null;
        if (resolvedString != null && resolvedString.trim().length() == 0) {
            resolvedString = null;
        }
        return resolvedString;
    }

    public static Extension extractExtension(OperationContext operationContext, ModelNode dataSourceNode, SimpleAttributeDefinition classNameAttribute, PropertiesAttributeDefinition propertyNameAttribute) throws ValidateException, OperationFailedException {
        return ModelNodeUtil.extractExtension(operationContext, dataSourceNode, classNameAttribute, null, propertyNameAttribute);
    }

    public static Extension extractExtension(OperationContext operationContext, ModelNode dataSourceNode, SimpleAttributeDefinition classNameAttribute, SimpleAttributeDefinition moduleNameAttribute, PropertiesAttributeDefinition propertyNameAttribute) throws ValidateException, OperationFailedException {
        if (dataSourceNode.hasDefined(classNameAttribute.getName())) {
            Map unwrapped;
            String className = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, classNameAttribute);
            String moduleName = null;
            if (moduleNameAttribute != null) {
                moduleName = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, moduleNameAttribute);
            }
            ModuleClassLoader moduleClassLoader = null;
            if (moduleName != null) {
                try {
                    moduleClassLoader = Module.getCallerModuleLoader().loadModule(moduleName).getClassLoader();
                }
                catch (ModuleLoadException exception) {
                    throw ROOT_LOGGER.wrongModuleName(exception, moduleName);
                }
            }
            Map property = (unwrapped = propertyNameAttribute.unwrap((ExpressionResolver)operationContext, dataSourceNode)).size() > 0 ? unwrapped : null;
            return new Extension(className, (ClassLoader)moduleClassLoader, property);
        }
        return null;
    }

    public static Map<String, String> extractMap(ModelNode operation, ObjectListAttributeDefinition objList, SimpleAttributeDefinition keyAttribute, SimpleAttributeDefinition valueAttribute) {
        HashMap<String, String> returnMap = null;
        if (operation.hasDefined(objList.getName())) {
            returnMap = new HashMap<String, String>(operation.get(objList.getName()).asList().size());
            for (ModelNode node : operation.get(objList.getName()).asList()) {
                returnMap.put(node.asObject().get(keyAttribute.getName()).asString(), node.asObject().get(valueAttribute.getName()).asString());
            }
        }
        return returnMap;
    }
}

