/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.MemoryStorageConfiguration;
import org.infinispan.configuration.cache.MemoryStorageConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class MemoryConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<MemoryConfiguration> {
    private MemoryStorageConfigurationBuilder memoryStorageConfigurationBuilder;
    private final AttributeSet attributes;
    private final List<String> legacyAttributesUsed = new ArrayList<String>();
    private boolean newAttributesUsed = false;
    private boolean isInListener = false;

    MemoryConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.memoryStorageConfigurationBuilder = new MemoryStorageConfigurationBuilder(builder);
        this.attributes = MemoryConfiguration.attributeDefinitionSet();
        this.attributes.attribute(MemoryConfiguration.STORAGE).addListener(this.nonReentrantListener((attribute, oldValue) -> this.memoryStorageAttribute(MemoryStorageConfiguration.STORAGE_TYPE).set((Object)((StorageType)((Object)((Object)attribute.get()))))));
        this.attributes.attribute(MemoryConfiguration.WHEN_FULL).addListener(this.nonReentrantListener((attribute, oldValue) -> this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_STRATEGY).set((Object)((EvictionStrategy)((Object)((Object)attribute.get()))))));
        this.attributes.attribute(MemoryConfiguration.MAX_COUNT).addListener(this.nonReentrantListener((attribute, oldValue) -> this.updateMaxCount((Long)attribute.get())));
        this.attributes.attribute(MemoryConfiguration.MAX_SIZE).addListener(this.nonReentrantListener((attribute, oldValue) -> this.updateMaxSize((String)attribute.get())));
        this.memoryStorageAttribute(MemoryStorageConfiguration.STORAGE_TYPE).addListener(this.nonReentrantListener((attribute, oldValue) -> this.attributes.attribute(MemoryConfiguration.STORAGE).set((Object)((StorageType)((Object)((Object)attribute.get()))))));
        this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_STRATEGY).addListener(this.nonReentrantListener((attribute, oldValue) -> this.attributes.attribute(MemoryConfiguration.WHEN_FULL).set((Object)((EvictionStrategy)((Object)((Object)attribute.get()))))));
        this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE).addListener(this.nonReentrantListener((attribute, oldValue) -> {
            long size = (Long)this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).get();
            if (size == -1L) {
                return;
            }
            this.updateLegacySize((EvictionType)((Object)((Object)attribute.get())), size);
        }));
        this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).addListener(this.nonReentrantListener((attribute, oldValue) -> {
            EvictionType evictionType = (EvictionType)((Object)((Object)this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE).get()));
            this.updateLegacySize(evictionType, (Long)attribute.get());
        }));
    }

    private <T> AttributeListener<T> nonReentrantListener(AttributeListener<T> listener) {
        return (attribute, oldValue) -> {
            if (this.isInListener) {
                return;
            }
            this.isInListener = true;
            try {
                listener.attributeChanged(attribute, oldValue);
            }
            finally {
                this.isInListener = false;
            }
        };
    }

    @Deprecated
    public MemoryConfigurationBuilder storageType(StorageType storageType) {
        return this.storage(storageType);
    }

    public MemoryConfigurationBuilder storage(StorageType storageType) {
        this.attributes.attribute(MemoryConfiguration.STORAGE).set((Object)storageType);
        return this;
    }

    public MemoryConfigurationBuilder maxSize(String size) {
        this.newAttributesUsed = true;
        this.attributes.attribute(MemoryConfiguration.MAX_SIZE).set((Object)size);
        return this;
    }

    public String maxSize() {
        return (String)this.attributes.attribute(MemoryConfiguration.MAX_SIZE).get();
    }

    public MemoryConfigurationBuilder maxCount(long count) {
        this.newAttributesUsed = true;
        this.attributes.attribute(MemoryConfiguration.MAX_COUNT).set((Object)count);
        return this;
    }

    public long maxCount() {
        return (Long)this.attributes.attribute(MemoryConfiguration.MAX_COUNT).get();
    }

    @Deprecated
    public StorageType storageType() {
        return this.storage();
    }

    public StorageType storage() {
        return (StorageType)((Object)this.attributes.attribute(MemoryConfiguration.STORAGE).get());
    }

    @Deprecated
    public MemoryConfigurationBuilder size(long size) {
        this.legacyAttributesUsed.add(MemoryStorageConfiguration.SIZE.name());
        this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).set((Object)size);
        return this;
    }

    @Deprecated
    public long size() {
        return (Long)this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).get();
    }

    @Deprecated
    public MemoryConfigurationBuilder evictionType(EvictionType type) {
        this.legacyAttributesUsed.add(MemoryStorageConfiguration.EVICTION_TYPE.name());
        this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE).set((Object)type);
        return this;
    }

    private <T> Attribute<T> memoryStorageAttribute(AttributeDefinition<T> attributeDefinition) {
        return this.memoryStorageConfigurationBuilder.attributes.attribute(attributeDefinition);
    }

    @Deprecated
    public EvictionType evictionType() {
        return (EvictionType)((Object)this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE).get());
    }

    @Deprecated
    public MemoryConfigurationBuilder evictionStrategy(EvictionStrategy strategy) {
        return this.whenFull(strategy);
    }

    public MemoryConfigurationBuilder whenFull(EvictionStrategy strategy) {
        this.attributes.attribute(MemoryConfiguration.WHEN_FULL).set((Object)strategy);
        return this;
    }

    public EvictionStrategy whenFull() {
        return (EvictionStrategy)((Object)this.attributes.attribute(MemoryConfiguration.WHEN_FULL).get());
    }

    @Deprecated
    public EvictionStrategy evictionStrategy() {
        return this.whenFull();
    }

    boolean isSizeBounded() {
        return this.maxSize() != null;
    }

    boolean isCountBounded() {
        return this.maxCount() > 0L;
    }

    private void checkBinaryRequirement() {
        boolean storageBinary;
        String keyType = this.encoding().key().mediaType();
        String valueType = this.encoding().value().mediaType();
        if (!this.storageType().canStoreReferences() && this.getBuilder().clustering().hash().groups().isEnabled()) {
            throw Log.CONFIG.groupingOnlyCompatibleWithObjectStorage(keyType, valueType);
        }
        boolean bl = storageBinary = this.encoding().isStorageBinary() || !this.storageType().canStoreReferences();
        if (this.isSizeBounded() && !storageBinary) {
            throw Log.CONFIG.offHeapMemoryEvictionNotSupportedWithObject();
        }
    }

    public void validate() {
        if (this.newAttributesUsed && !this.legacyAttributesUsed.isEmpty()) {
            throw Log.CONFIG.cannotUseDeprecatedAndReplacement(this.legacyAttributesUsed.toString());
        }
        if (this.isSizeBounded() && this.isCountBounded()) {
            throw Log.CONFIG.cannotProvideBothSizeAndCount();
        }
        EvictionStrategy strategy = this.evictionStrategy();
        if (strategy.isEnabled()) {
            TransactionConfigurationBuilder transactionConfiguration;
            TransactionMode transactionMode;
            if (!this.isCountBounded() && !this.isSizeBounded()) {
                throw Log.CONFIG.invalidEvictionSize();
            }
            if (strategy.isExceptionBased() && ((transactionMode = (transactionConfiguration = this.getBuilder().transaction()).transactionMode()) == null || !transactionMode.isTransactional() || transactionConfiguration.useSynchronization() || transactionConfiguration.use1PcForAutoCommitTransactions())) {
                throw Log.CONFIG.exceptionBasedEvictionOnlySupportedInTransactionalCaches();
            }
        } else if (this.getBuilder().persistence().passivation() && strategy != EvictionStrategy.MANUAL && !this.getBuilder().template() && !this.isSizeBounded() && !this.isCountBounded()) {
            Log.CONFIG.passivationWithoutEviction();
        }
        this.checkBinaryRequirement();
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public MemoryConfiguration create() {
        Attribute whenFull = this.attributes.attribute(MemoryConfiguration.WHEN_FULL);
        if (!((EvictionStrategy)((Object)whenFull.get())).isEnabled() && (this.isSizeBounded() || this.isCountBounded())) {
            whenFull.setImplied((Object)EvictionStrategy.REMOVE);
            if (this.isCountBounded()) {
                Log.CONFIG.debugf("Max entries configured (%d) without eviction strategy. Eviction strategy overridden to %s", this.maxCount(), whenFull.get());
            } else {
                Log.CONFIG.debugf("Max size configured (%s) without eviction strategy. Eviction strategy overridden to %s", this.maxSize(), whenFull.get());
            }
        }
        return new MemoryConfiguration(this.attributes.protect(), this.memoryStorageConfigurationBuilder.create());
    }

    public MemoryConfigurationBuilder read(MemoryConfiguration template) {
        this.attributes.read(template.attributes());
        if (this.attributes.attribute(MemoryConfiguration.STORAGE).isModified()) {
            this.memoryStorageAttribute(MemoryStorageConfiguration.STORAGE_TYPE).set((Object)this.storage());
        }
        if (this.attributes.attribute(MemoryConfiguration.WHEN_FULL).isModified()) {
            this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_STRATEGY).set((Object)this.whenFull());
        }
        if (this.attributes.attribute(MemoryConfiguration.MAX_COUNT).isModified()) {
            this.updateMaxCount(this.maxCount());
        }
        if (this.attributes.attribute(MemoryConfiguration.MAX_SIZE).isModified()) {
            this.updateMaxSize(this.maxSize());
        }
        return this;
    }

    private void updateMaxSize(String maxSize) {
        Attribute<EvictionType> evictionTypeAttribute = this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE);
        if (maxSize != null && evictionTypeAttribute.get() != EvictionType.MEMORY) {
            evictionTypeAttribute.set((Object)EvictionType.MEMORY);
        }
        if (maxSize != null || this.maxCount() == -1L) {
            long maxSizeBytes = MemoryConfiguration.maxSizeToBytes(maxSize);
            this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).set((Object)maxSizeBytes);
        }
    }

    private void updateMaxCount(long maxCount) {
        Attribute<EvictionType> evictionTypeAttribute = this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE);
        if (maxCount != -1L && evictionTypeAttribute.get() != EvictionType.COUNT) {
            evictionTypeAttribute.set((Object)EvictionType.COUNT);
        }
        if (maxCount != -1L || this.maxSize() == null) {
            this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).set((Object)maxCount);
        }
    }

    private void updateLegacySize(EvictionType type, Long size) {
        switch (type) {
            case COUNT: {
                if (this.attributes.attribute(MemoryConfiguration.MAX_SIZE).get() != null) {
                    this.attributes.attribute(MemoryConfiguration.MAX_SIZE).reset();
                }
                this.attributes.attribute(MemoryConfiguration.MAX_COUNT).set((Object)size);
                break;
            }
            case MEMORY: {
                if ((Long)this.attributes.attribute(MemoryConfiguration.MAX_COUNT).get() != -1L) {
                    this.attributes.attribute(MemoryConfiguration.MAX_COUNT).reset();
                }
                this.attributes.attribute(MemoryConfiguration.MAX_SIZE).set((Object)String.valueOf(size));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String toString() {
        return "MemoryConfigurationBuilder{memoryStorageConfigurationBuilder=" + this.memoryStorageConfigurationBuilder + ", attributes=" + this.attributes + '}';
    }
}

