/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.operations.GetAllOperation;
import org.infinispan.client.hotrod.impl.operations.ParallelHotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

public class GetAllParallelOperation<K, V>
extends ParallelHotRodOperation<Map<K, V>, GetAllOperation<K, V>> {
    private final Set<byte[]> keys;

    protected GetAllParallelOperation(Codec codec, ChannelFactory channelFactory, Set<byte[]> keys, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, DataFormat dataFormat, ClientStatistics clientStatistics) {
        super(codec, channelFactory, cacheName, topologyId, flags, cfg, dataFormat, clientStatistics);
        this.keys = keys;
    }

    @Override
    protected List<GetAllOperation<K, V>> mapOperations() {
        HashMap<SocketAddress, Set> splittedKeys = new HashMap<SocketAddress, Set>();
        for (byte[] key : this.keys) {
            SocketAddress socketAddress = this.channelFactory.getHashAwareServer(key, this.cacheName);
            Set keys = splittedKeys.computeIfAbsent(socketAddress, k -> new HashSet());
            keys.add(key);
        }
        return splittedKeys.values().stream().map(keysSubset -> new GetAllOperation(this.codec, this.channelFactory, (Set<byte[]>)keysSubset, this.cacheName, this.header.topologyId(), this.flags, this.cfg, this.dataFormat, this.clientStatistics)).collect(Collectors.toList());
    }

    @Override
    protected Map<K, V> createCollector() {
        return new HashMap();
    }

    @Override
    protected void combine(Map<K, V> collector, Map<K, V> result) {
        collector.putAll(result);
    }
}

