/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.common;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceName;

public class VirtualHttpServerMechanismFactoryMarkerUtility {
    private static final AttachmentKey<Boolean> REQUIRED = AttachmentKey.create(Boolean.class);
    private static final ServiceName MECHANISM_FACTORY_SUFFIX = ServiceName.of((String[])new String[]{"http-server-mechanism-factory", "virtual"});

    public static void virtualMechanismFactoryRequired(DeploymentUnit deploymentUnit) {
        DeploymentUnit rootUnit = VirtualHttpServerMechanismFactoryMarkerUtility.toRoot(deploymentUnit);
        rootUnit.putAttachment(REQUIRED, (Object)Boolean.TRUE);
    }

    public static boolean isVirtualMechanismFactoryRequired(DeploymentUnit deploymentUnit) {
        DeploymentUnit rootUnit = VirtualHttpServerMechanismFactoryMarkerUtility.toRoot(deploymentUnit);
        Boolean required = (Boolean)rootUnit.getAttachment(REQUIRED);
        return required == null ? false : required;
    }

    public static ServiceName virtualMechanismFactoryName(DeploymentUnit deploymentUnit) {
        DeploymentUnit rootUnit = VirtualHttpServerMechanismFactoryMarkerUtility.toRoot(deploymentUnit);
        return rootUnit.getServiceName().append(MECHANISM_FACTORY_SUFFIX);
    }

    private static DeploymentUnit toRoot(DeploymentUnit deploymentUnit) {
        DeploymentUnit result = deploymentUnit;
        DeploymentUnit parent = result.getParent();
        while (parent != null) {
            result = parent;
            parent = result.getParent();
        }
        return result;
    }
}

