/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import java.util.EnumSet;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.AddressBindingInfo;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.AddressStatusEncoding;
import org.apache.activemq.artemis.utils.Preconditions;

public class PersistentAddressBindingEncoding
implements EncodingSupport,
AddressBindingInfo {
    public long id;
    public SimpleString name;
    public boolean autoCreated;
    public AddressStatusEncoding addressStatusEncoding;
    public EnumSet<RoutingType> routingTypes;

    public PersistentAddressBindingEncoding() {
        this.routingTypes = EnumSet.noneOf(RoutingType.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PersistentAddressBindingEncoding [id=" + this.id);
        sb.append(", name=" + this.name);
        sb.append(", routingTypes={");
        for (RoutingType routingType : this.routingTypes) {
            sb.append(routingType.toString() + ",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        sb.append(", autoCreated=" + this.autoCreated + "]");
        return sb.toString();
    }

    public PersistentAddressBindingEncoding(SimpleString name, EnumSet<RoutingType> routingTypes, boolean autoCreated) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(routingTypes);
        this.name = name;
        this.routingTypes = routingTypes;
        this.autoCreated = autoCreated;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public boolean getAutoCreated() {
        return this.autoCreated;
    }

    @Override
    public EnumSet<RoutingType> getRoutingTypes() {
        return this.routingTypes;
    }

    @Override
    public AddressStatusEncoding getAddressStatusEncoding() {
        return this.addressStatusEncoding;
    }

    public void setAddressStatusEncoding(AddressStatusEncoding addressStatusEncoding) {
        this.addressStatusEncoding = addressStatusEncoding;
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readSimpleString();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.routingTypes.add(RoutingType.getType((byte)buffer.readByte()));
        }
        this.autoCreated = buffer.readBoolean();
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.name);
        buffer.writeInt(this.routingTypes.size());
        for (RoutingType d : this.routingTypes) {
            buffer.writeByte(d.getType());
        }
        buffer.writeBoolean(this.autoCreated);
    }

    public int getEncodeSize() {
        return SimpleString.sizeofString((SimpleString)this.name) + 4 + 1 * this.routingTypes.size() + 1;
    }
}

