/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.wildfly.clustering.infinispan.spi.persistence.BinaryKeyFormat;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.marshalling.spi.SerializerExternalizer;
import org.wildfly.clustering.server.group.AddressSerializer;
import org.wildfly.clustering.server.group.AddressableNode;

public enum AddressableNodeSerializer implements Serializer<AddressableNode>
{
    INSTANCE;


    public void write(DataOutput output, AddressableNode node) throws IOException {
        AddressSerializer.INSTANCE.write(output, node.getAddress());
        output.writeUTF(node.getName());
        if (!(node.getAddress() instanceof IpAddress)) {
            InetSocketAddress socketAddress = node.getSocketAddress();
            byte[] address = socketAddress.getAddress().getAddress();
            IndexSerializer.UNSIGNED_BYTE.writeInt(output, address.length);
            output.write(address);
            IndexSerializer.UNSIGNED_SHORT.writeInt(output, socketAddress.getPort());
        }
    }

    public AddressableNode read(DataInput input) throws IOException {
        Address jgroupsAddress = AddressSerializer.INSTANCE.read(input);
        String name = input.readUTF();
        if (jgroupsAddress instanceof IpAddress) {
            return new AddressableNode((IpAddress)jgroupsAddress, name);
        }
        byte[] address = new byte[IndexSerializer.UNSIGNED_BYTE.readInt(input)];
        input.readFully(address);
        int port = IndexSerializer.UNSIGNED_SHORT.readInt(input);
        return new AddressableNode(jgroupsAddress, name, new InetSocketAddress(InetAddress.getByAddress(address), port));
    }

    public static class AddressableNodeKeyFormat
    extends BinaryKeyFormat<AddressableNode> {
        public AddressableNodeKeyFormat() {
            super(AddressableNode.class, (Serializer)INSTANCE);
        }
    }

    public static class AddressableNodeExternalizer
    extends SerializerExternalizer<AddressableNode> {
        public AddressableNodeExternalizer() {
            super(AddressableNode.class, (Serializer)INSTANCE);
        }
    }
}

