/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.domain.management.audit.AccessAuditResourceDefinition;
import org.jboss.as.domain.management.audit.AuditLogLoggerResourceDefinition;
import org.jboss.as.domain.management.audit.FileAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.InMemoryAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.JsonAuditLogFormatterResourceDefinition;
import org.jboss.as.domain.management.audit.KeystoreAttributes;
import org.jboss.as.domain.management.audit.PeriodicRotatingFileAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.SizeRotatingFileAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.SyslogAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.SyslogAuditLogProtocolResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.parsing.AuditLogXml;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class AuditLogXml_5
implements AuditLogXml {
    final boolean host;

    AuditLogXml_5(boolean host) {
        this.host = host;
    }

    private void parseFileAuditLogHandler(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = Util.createAddOperation();
        list.add(add);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("file-handler", value);
                    continue block8;
                }
                case MAX_FAILURE_COUNT: {
                    FileAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case FORMATTER: {
                    FileAuditLogHandlerResourceDefinition.FORMATTER.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case PATH: {
                    FileAuditLogHandlerResourceDefinition.PATH.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case RELATIVE_TO: {
                    FileAuditLogHandlerResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case ROTATE_AT_STARTUP: {
                    FileAuditLogHandlerResourceDefinition.ROTATE_AT_STARTUP.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void writeFileAuditLogHandler(XMLExtendedStreamWriter writer, ModelNode auditLog, String name) throws XMLStreamException {
        if (auditLog.hasDefined(new String[]{"file-handler", name})) {
            writer.writeStartElement(Element.FILE_HANDLER.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            ModelNode handler = auditLog.get(new String[]{"file-handler", name});
            FileAuditLogHandlerResourceDefinition.FORMATTER.marshallAsAttribute(handler, (XMLStreamWriter)writer);
            FileAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.marshallAsAttribute(handler, (XMLStreamWriter)writer);
            FileAuditLogHandlerResourceDefinition.PATH.marshallAsAttribute(handler, (XMLStreamWriter)writer);
            FileAuditLogHandlerResourceDefinition.RELATIVE_TO.marshallAsAttribute(handler, (XMLStreamWriter)writer);
            FileAuditLogHandlerResourceDefinition.ROTATE_AT_STARTUP.marshallAsAttribute(handler, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    @Override
    public void parseAuditLog(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        ModelNode auditLogAddress = address.clone().add(AccessAuditResourceDefinition.PATH_ELEMENT.getKey(), AccessAuditResourceDefinition.PATH_ELEMENT.getValue());
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        add.get("address").set(auditLogAddress);
        list.add(add);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case FORMATTERS: {
                    this.parseAuditLogFormatters(reader, auditLogAddress, expectedNs, list);
                    continue block6;
                }
                case HANDLERS: {
                    this.parseAuditLogHandlers(reader, auditLogAddress, expectedNs, list);
                    continue block6;
                }
                case LOGGER: {
                    this.parseAuditLogConfig(reader, auditLogAddress, expectedNs, AuditLogLoggerResourceDefinition.PATH_ELEMENT, list);
                    continue block6;
                }
                case SERVER_LOGGER: {
                    if (!this.host) break;
                    this.parseAuditLogConfig(reader, auditLogAddress, expectedNs, AuditLogLoggerResourceDefinition.HOST_SERVER_PATH_ELEMENT, list);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuditLogFormatters(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JSON_FORMATTER: {
                    this.parseFileAuditLogFormatter(reader, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseFileAuditLogFormatter(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = Util.createAddOperation();
        list.add(add);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("json-formatter", value);
                    continue block9;
                }
                case COMPACT: {
                    JsonAuditLogFormatterResourceDefinition.COMPACT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case DATE_FORMAT: {
                    JsonAuditLogFormatterResourceDefinition.DATE_FORMAT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case DATE_SEPARATOR: {
                    JsonAuditLogFormatterResourceDefinition.DATE_SEPARATOR.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case ESCAPE_CONTROL_CHARACTERS: {
                    JsonAuditLogFormatterResourceDefinition.ESCAPE_CONTROL_CHARACTERS.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case ESCAPE_NEW_LINE: {
                    JsonAuditLogFormatterResourceDefinition.ESCAPE_NEW_LINE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case INCLUDE_DATE: {
                    JsonAuditLogFormatterResourceDefinition.INCLUDE_DATE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseAuditLogHandlers(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        boolean configurationChangesConfigured = false;
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case IN_MEMORY_HANDLER: {
                    if (configurationChangesConfigured) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseConfigurationChangesAuditLogHandler(reader, address, list);
                    configurationChangesConfigured = true;
                    continue block7;
                }
                case FILE_HANDLER: {
                    this.parseFileAuditLogHandler(reader, address, list);
                    continue block7;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    this.parsePeriodicRotatingFileAuditLogHandler(reader, address, list);
                    continue block7;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    this.parseSizeRotatingFileAuditLogHandler(reader, address, list);
                    continue block7;
                }
                case SYSLOG_HANDLER: {
                    this.parseSyslogAuditLogHandler(reader, address, expectedNs, list);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseConfigurationChangesAuditLogHandler(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = Util.createAddOperation();
        list.add(add);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("in-memory-handler", value);
                    continue block4;
                }
                case MAX_HISTORY: {
                    InMemoryAuditLogHandlerResourceDefinition.MAX_OPERATION_COUNT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseSizeRotatingFileAuditLogHandler(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = Util.createAddOperation();
        list.add(add);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("size-rotating-file-handler", value);
                    continue block9;
                }
                case MAX_FAILURE_COUNT: {
                    SizeRotatingFileAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case FORMATTER: {
                    SizeRotatingFileAuditLogHandlerResourceDefinition.FORMATTER.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case PATH: {
                    SizeRotatingFileAuditLogHandlerResourceDefinition.PATH.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case RELATIVE_TO: {
                    SizeRotatingFileAuditLogHandlerResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case ROTATE_SIZE: {
                    SizeRotatingFileAuditLogHandlerResourceDefinition.ROTATE_SIZE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case MAX_BACKUP_INDEX: {
                    SizeRotatingFileAuditLogHandlerResourceDefinition.MAX_BACKUP_INDEX.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePeriodicRotatingFileAuditLogHandler(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = Util.createAddOperation();
        list.add(add);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("periodic-rotating-file-handler", value);
                    continue block8;
                }
                case MAX_FAILURE_COUNT: {
                    PeriodicRotatingFileAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case FORMATTER: {
                    PeriodicRotatingFileAuditLogHandlerResourceDefinition.FORMATTER.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case PATH: {
                    PeriodicRotatingFileAuditLogHandlerResourceDefinition.PATH.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case RELATIVE_TO: {
                    PeriodicRotatingFileAuditLogHandlerResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case SUFFIX: {
                    PeriodicRotatingFileAuditLogHandlerResourceDefinition.SUFFIX.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseSyslogAuditLogHandlerAttributes(XMLExtendedStreamReader reader, ModelNode address, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    addOp.get("address").set(address).add("syslog-handler", value);
                    continue block10;
                }
                case MAX_FAILURE_COUNT: {
                    SyslogAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case FORMATTER: {
                    SyslogAuditLogHandlerResourceDefinition.FORMATTER.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case MAX_LENGTH: {
                    SyslogAuditLogHandlerResourceDefinition.MAX_LENGTH.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case TRUNCATE: {
                    SyslogAuditLogHandlerResourceDefinition.TRUNCATE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case FACILITY: {
                    SyslogAuditLogHandlerResourceDefinition.FACILITY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case APP_NAME: {
                    SyslogAuditLogHandlerResourceDefinition.APP_NAME.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case SYSLOG_FORMAT: {
                    SyslogAuditLogHandlerResourceDefinition.SYSLOG_FORMAT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseSyslogAuditLogHandler(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = Util.createAddOperation();
        list.add(add);
        this.parseSyslogAuditLogHandlerAttributes(reader, address, add);
        if (!add.get("address").isDefined()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        boolean protocolSet = false;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (protocolSet) {
                throw DomainManagementLogger.ROOT_LOGGER.onlyOneSyslogHandlerProtocol(reader.getLocation());
            }
            protocolSet = true;
            switch (element) {
                case UDP: 
                case TCP: 
                case TLS: {
                    this.parseSyslogAuditLogHandlerProtocol(reader, add.get("address"), expectedNs, list, element);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSyslogAuditLogHandlerProtocol(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, Element protocolElement) throws XMLStreamException {
        PathAddress protocolAddress = PathAddress.pathAddress((ModelNode)address.clone().add("protocol", protocolElement.getLocalName()));
        ModelNode add = Util.createAddOperation((PathAddress)protocolAddress);
        list.add(add);
        int tcpCount = reader.getAttributeCount();
        block10: for (int i = 0; i < tcpCount; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    SyslogAuditLogProtocolResourceDefinition.Udp.HOST.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block10;
                }
                case PORT: {
                    SyslogAuditLogProtocolResourceDefinition.Udp.PORT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block10;
                }
                case MESSAGE_TRANSFER: {
                    if (protocolElement != Element.UDP) {
                        SyslogAuditLogProtocolResourceDefinition.Tcp.MESSAGE_TRANSFER.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                        continue block10;
                    }
                }
                case RECONNECT_TIMEOUT: {
                    if (protocolElement != Element.UDP) {
                        SyslogAuditLogProtocolResourceDefinition.Tcp.RECONNECT_TIMEOUT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                        continue block10;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (protocolElement != Element.TLS) {
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        } else {
            boolean seenTrustStore = false;
            boolean seenClientCertStore = false;
            block11: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                Element element = Element.forName((String)reader.getLocalName());
                switch (element) {
                    case TRUSTSTORE: {
                        if (seenTrustStore) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.TRUSTSTORE.getLocalName());
                        }
                        seenTrustStore = true;
                        this.parseSyslogTlsKeystore(reader, protocolAddress, expectedNs, list, SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.TRUSTSTORE_ELEMENT, false);
                        continue block11;
                    }
                    case CLIENT_CERT_STORE: {
                        if (seenClientCertStore) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.CLIENT_CERT_STORE.getLocalName());
                        }
                        seenClientCertStore = true;
                        this.parseSyslogTlsKeystore(reader, protocolAddress, expectedNs, list, SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.CLIENT_CERT_ELEMENT, true);
                        continue block11;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseSyslogTlsKeystore(XMLExtendedStreamReader reader, PathAddress address, Namespace expectedNs, List<ModelNode> list, PathElement storeAddress, boolean hasKeyPassword) throws XMLStreamException {
        ModelNode add = Util.createAddOperation((PathAddress)address.append(new PathElement[]{storeAddress}));
        list.add(add);
        int tcpCount = reader.getAttributeCount();
        block10: for (int i = 0; i < tcpCount; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEYSTORE_PASSWORD: {
                    SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block10;
                }
                case PATH: {
                    SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PATH.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block10;
                }
                case RELATIVE_TO: {
                    SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block10;
                }
                case KEY_PASSWORD: {
                    if (hasKeyPassword) {
                        SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEY_PASSWORD.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                        continue block10;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE: {
                    KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.getParser().parseElement((AttributeDefinition)KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE, reader, add);
                    continue block11;
                }
                case KEY_PASSWORD_CREDENTIAL_REFERENCE: {
                    KeystoreAttributes.KEY_PASSWORD_CREDENTIAL_REFERENCE.getParser().parseElement((AttributeDefinition)KeystoreAttributes.KEY_PASSWORD_CREDENTIAL_REFERENCE, reader, add);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuditLogConfig(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, PathElement pathElement, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        ModelNode configAddress = address.clone().add(pathElement.getKey(), pathElement.getValue());
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        add.get("address").set(configAddress);
        list.add(add);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case LOG_READ_ONLY: {
                    AuditLogLoggerResourceDefinition.LOG_READ_ONLY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case LOG_BOOT: {
                    AuditLogLoggerResourceDefinition.LOG_BOOT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case ENABLED: {
                    AuditLogLoggerResourceDefinition.ENABLED.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case HANDLERS: {
                    this.parseAuditLogHandlersReference(reader, configAddress, expectedNs, list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuditLogHandlersReference(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case HANDLER: {
                    ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                    ModelNode add = new ModelNode();
                    add.get("operation").set("add");
                    list.add(add);
                    int count = reader.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        String value = reader.getAttributeValue(i);
                        if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                        Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                add.get("address").set(address).add("handler", value);
                                break;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    }
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    @Override
    public void writeAuditLog(XMLExtendedStreamWriter writer, ModelNode auditLog) throws XMLStreamException {
        writer.writeStartElement(Element.AUDIT_LOG.getLocalName());
        if (auditLog.hasDefined("json-formatter") && !auditLog.get("json-formatter").keys().isEmpty()) {
            writer.writeStartElement(Element.FORMATTERS.getLocalName());
            for (Property prop : auditLog.get("json-formatter").asPropertyList()) {
                writer.writeStartElement(Element.JSON_FORMATTER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                JsonAuditLogFormatterResourceDefinition.COMPACT.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                JsonAuditLogFormatterResourceDefinition.DATE_FORMAT.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                JsonAuditLogFormatterResourceDefinition.DATE_SEPARATOR.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                JsonAuditLogFormatterResourceDefinition.ESCAPE_CONTROL_CHARACTERS.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                JsonAuditLogFormatterResourceDefinition.ESCAPE_NEW_LINE.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                JsonAuditLogFormatterResourceDefinition.INCLUDE_DATE.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (auditLog.hasDefined("file-handler") && !auditLog.get("file-handler").keys().isEmpty() || auditLog.hasDefined("syslog-handler") && !auditLog.get("syslog-handler").keys().isEmpty() || auditLog.hasDefined("size-rotating-file-handler") && !auditLog.get("size-rotating-file-handler").keys().isEmpty() || auditLog.hasDefined("periodic-rotating-file-handler") && !auditLog.get("periodic-rotating-file-handler").keys().isEmpty() || auditLog.hasDefined("in-memory-handler") && !auditLog.get("in-memory-handler").keys().isEmpty()) {
            ModelNode handler;
            writer.writeStartElement(Element.HANDLERS.getLocalName());
            if (auditLog.hasDefined("file-handler")) {
                for (String name : auditLog.get("file-handler").keys()) {
                    this.writeFileAuditLogHandler(writer, auditLog, name);
                }
            }
            if (auditLog.hasDefined("periodic-rotating-file-handler")) {
                for (String name : auditLog.get("periodic-rotating-file-handler").keys()) {
                    writer.writeStartElement(Element.PERIODIC_ROTATING_FILE_HANDLER.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    handler = auditLog.get(new String[]{"periodic-rotating-file-handler", name});
                    PeriodicRotatingFileAuditLogHandlerResourceDefinition.FORMATTER.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    PeriodicRotatingFileAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    PeriodicRotatingFileAuditLogHandlerResourceDefinition.PATH.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    PeriodicRotatingFileAuditLogHandlerResourceDefinition.RELATIVE_TO.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    PeriodicRotatingFileAuditLogHandlerResourceDefinition.SUFFIX.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
            }
            if (auditLog.hasDefined("size-rotating-file-handler")) {
                for (String name : auditLog.get("size-rotating-file-handler").keys()) {
                    writer.writeStartElement(Element.SIZE_ROTATING_FILE_HANDLER.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    handler = auditLog.get(new String[]{"size-rotating-file-handler", name});
                    SizeRotatingFileAuditLogHandlerResourceDefinition.FORMATTER.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SizeRotatingFileAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SizeRotatingFileAuditLogHandlerResourceDefinition.PATH.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SizeRotatingFileAuditLogHandlerResourceDefinition.RELATIVE_TO.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SizeRotatingFileAuditLogHandlerResourceDefinition.ROTATE_SIZE.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SizeRotatingFileAuditLogHandlerResourceDefinition.MAX_BACKUP_INDEX.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
            }
            if (auditLog.hasDefined("syslog-handler")) {
                for (String name : auditLog.get("syslog-handler").keys()) {
                    writer.writeStartElement(Element.SYSLOG_HANDLER.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    handler = auditLog.get(new String[]{"syslog-handler", name});
                    SyslogAuditLogHandlerResourceDefinition.FORMATTER.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SyslogAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SyslogAuditLogHandlerResourceDefinition.SYSLOG_FORMAT.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SyslogAuditLogHandlerResourceDefinition.MAX_LENGTH.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SyslogAuditLogHandlerResourceDefinition.TRUNCATE.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SyslogAuditLogHandlerResourceDefinition.FACILITY.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SyslogAuditLogHandlerResourceDefinition.APP_NAME.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    if (handler.hasDefined("protocol")) {
                        this.writeAuditLogSyslogProtocol(writer, handler.get("protocol"));
                    }
                    writer.writeEndElement();
                }
            }
            if (auditLog.hasDefined("in-memory-handler")) {
                for (String name : auditLog.get("in-memory-handler").keys()) {
                    writer.writeStartElement(Element.IN_MEMORY_HANDLER.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    handler = auditLog.get(new String[]{"in-memory-handler", name});
                    InMemoryAuditLogHandlerResourceDefinition.MAX_OPERATION_COUNT.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        this.writeAuditLogger(writer, auditLog, Element.LOGGER.getLocalName());
        this.writeAuditLogger(writer, auditLog, Element.SERVER_LOGGER.getLocalName());
        writer.writeEndElement();
    }

    private void writeAuditLogger(XMLExtendedStreamWriter writer, ModelNode auditLog, String element) throws XMLStreamException {
        if (auditLog.hasDefined(element) && auditLog.get(element).hasDefined("audit-log")) {
            ModelNode config = auditLog.get(new String[]{element, "audit-log"});
            writer.writeStartElement(element);
            AuditLogLoggerResourceDefinition.LOG_BOOT.marshallAsAttribute(config, (XMLStreamWriter)writer);
            AuditLogLoggerResourceDefinition.LOG_READ_ONLY.marshallAsAttribute(config, (XMLStreamWriter)writer);
            AuditLogLoggerResourceDefinition.ENABLED.marshallAsAttribute(config, (XMLStreamWriter)writer);
            if (config.hasDefined("handler") && !config.get("handler").keys().isEmpty()) {
                writer.writeStartElement(Element.HANDLERS.getLocalName());
                for (String name : config.get("handler").keys()) {
                    writer.writeStartElement(Element.HANDLER.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeAuditLogSyslogProtocol(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        String type = (String)protocol.keys().iterator().next();
        ModelNode protocolContents = protocol.get(type);
        if (type.equals("udp")) {
            writer.writeStartElement(type);
            SyslogAuditLogProtocolResourceDefinition.Udp.HOST.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Udp.PORT.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if (type.equals("tcp")) {
            writer.writeStartElement(type);
            SyslogAuditLogProtocolResourceDefinition.Tcp.HOST.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Tcp.PORT.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Tcp.MESSAGE_TRANSFER.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Tcp.RECONNECT_TIMEOUT.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if (type.equals("tls")) {
            writer.writeStartElement(type);
            SyslogAuditLogProtocolResourceDefinition.Tls.HOST.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Tls.PORT.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Tls.MESSAGE_TRANSFER.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Tcp.RECONNECT_TIMEOUT.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            if (protocolContents.hasDefined("authentication")) {
                this.writeAuditLogSyslogTlsProtocolKeyStore(writer, protocolContents.get("authentication"), "truststore");
                this.writeAuditLogSyslogTlsProtocolKeyStore(writer, protocolContents.get("authentication"), "client-certificate-store");
            }
            writer.writeEndElement();
        }
    }

    private void writeAuditLogSyslogTlsProtocolKeyStore(XMLExtendedStreamWriter writer, ModelNode keystoreParent, String name) throws XMLStreamException {
        if (keystoreParent.hasDefined(name)) {
            ModelNode keystore = keystoreParent.get(name);
            writer.writeStartElement(name);
            SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PATH.marshallAsAttribute(keystore, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_RELATIVE_TO.marshallAsAttribute(keystore, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD.marshallAsAttribute(keystore, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEY_PASSWORD.marshallAsAttribute(keystore, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.marshallAsElement(keystore, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEY_PASSWORD_CREDENTIAL_REFERENCE.marshallAsElement(keystore, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }
}

