/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingResourceDefinition;
import org.jboss.as.logging.LoggingSubsystemParser_1_3;
import org.jboss.as.logging.formatters.PatternFormatterResourceDefinition;
import org.jboss.as.logging.handlers.AbstractHandlerDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class LoggingSubsystemParser_1_4
extends LoggingSubsystemParser_1_3 {
    LoggingSubsystemParser_1_4() {
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode subsystemAddOp = Util.createAddOperation((PathAddress)SUBSYSTEM_ADDRESS);
        operations.add(subsystemAddOp);
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> formatterOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        HashSet<String> formatterNames = new HashSet<String>();
        boolean rootDefined = false;
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADD_LOGGING_API_DEPENDENCIES: {
                    String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                    LoggingResourceDefinition.ADD_LOGGING_API_DEPENDENCIES.parseAndSetParameter(value, subsystemAddOp, (XMLStreamReader)reader);
                    continue block14;
                }
                case LOGGER: {
                    this.parseLoggerElement(reader, SUBSYSTEM_ADDRESS, loggerOperations, loggerNames);
                    continue block14;
                }
                case ROOT_LOGGER: {
                    if (rootDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    rootDefined = true;
                    this.parseRootLoggerElement(reader, SUBSYSTEM_ADDRESS, loggerOperations);
                    continue block14;
                }
                case CONSOLE_HANDLER: {
                    this.parseConsoleHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block14;
                }
                case FILE_HANDLER: {
                    this.parseFileHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block14;
                }
                case CUSTOM_HANDLER: {
                    this.parseCustomHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block14;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    this.parsePeriodicRotatingFileHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block14;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    this.parseSizeRotatingHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block14;
                }
                case ASYNC_HANDLER: {
                    this.parseAsyncHandlerElement(reader, SUBSYSTEM_ADDRESS, asyncHandlerOperations, handlerNames);
                    continue block14;
                }
                case SYSLOG_HANDLER: {
                    this.parseSyslogHandler(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block14;
                }
                case LOGGING_PROFILES: {
                    this.parseLoggingProfilesElement(reader, operations);
                    continue block14;
                }
                case FORMATTER: {
                    this.parseFormatter(reader, SUBSYSTEM_ADDRESS, formatterOperations, formatterNames);
                    continue block14;
                }
            }
            reader.handleAny(operations);
        }
        operations.addAll(formatterOperations);
        operations.addAll(handlerOperations);
        operations.addAll(asyncHandlerOperations);
        operations.addAll(loggerOperations);
    }

    void parseFormatter(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block8: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PATTERN_FORMATTER: {
                    ModelNode operation = Util.createAddOperation();
                    LoggingSubsystemParser_1_4.addOperationAddress(operation, address, "pattern-formatter", name);
                    this.parsePatternFormatterElement(reader, operation);
                    operations.add(operation);
                    continue block8;
                }
                case CUSTOM_FORMATTER: {
                    ModelNode operation = Util.createAddOperation();
                    LoggingSubsystemParser_1_4.addOperationAddress(operation, address, "custom-formatter", name);
                    this.parseCustomFormatterElement(reader, operation);
                    operations.add(operation);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    @Override
    void parseHandlerFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        boolean formatterDefined = false;
        block4: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PATTERN_FORMATTER: {
                    if (formatterDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)PatternFormatterResourceDefinition.PATTERN.getName());
                    formatterDefined = true;
                    AbstractHandlerDefinition.FORMATTER.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)PatternFormatterResourceDefinition.PATTERN.getName()), operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case NAMED_FORMATTER: {
                    if (formatterDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    formatterDefined = true;
                    AbstractHandlerDefinition.NAMED_FORMATTER.parseAndSetParameter(LoggingSubsystemParser_1_4.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parsePatternFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    PatternFormatterResourceDefinition.PATTERN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case COLOR_MAP: {
                    PatternFormatterResourceDefinition.COLOR_MAP.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void parseCustomFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CLASS, Attribute.MODULE);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CLASS: {
                    CommonAttributes.CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                case MODULE: {
                    CommonAttributes.MODULE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block8: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    LoggingSubsystemParser_1_4.parsePropertyElement(operation, reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    @Override
    void parseLoggingProfileElement(XMLExtendedStreamReader reader, List<ModelNode> operations, Set<String> profileNames) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!profileNames.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        PathAddress profileAddress = SUBSYSTEM_ADDRESS.append("logging-profile", name);
        operations.add(Util.createAddOperation((PathAddress)profileAddress));
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> formatterOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        HashSet<String> formatterNames = new HashSet<String>();
        boolean gotRoot = false;
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGER: {
                    this.parseLoggerElement(reader, profileAddress, loggerOperations, loggerNames);
                    continue block16;
                }
                case ROOT_LOGGER: {
                    if (gotRoot) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    gotRoot = true;
                    this.parseRootLoggerElement(reader, profileAddress, loggerOperations);
                    continue block16;
                }
                case CONSOLE_HANDLER: {
                    this.parseConsoleHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case FILE_HANDLER: {
                    this.parseFileHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case CUSTOM_HANDLER: {
                    this.parseCustomHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    this.parsePeriodicRotatingFileHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    this.parseSizeRotatingHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case ASYNC_HANDLER: {
                    this.parseAsyncHandlerElement(reader, profileAddress, asyncHandlerOperations, handlerNames);
                    continue block16;
                }
                case SYSLOG_HANDLER: {
                    this.parseSyslogHandler(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case FORMATTER: {
                    this.parseFormatter(reader, profileAddress, formatterOperations, formatterNames);
                    continue block16;
                }
            }
            reader.handleAny(operations);
        }
        operations.addAll(formatterOperations);
        operations.addAll(handlerOperations);
        operations.addAll(asyncHandlerOperations);
        operations.addAll(loggerOperations);
    }
}

