/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.thrift.internal.senders;

import io.jaegertracing.agent.thrift.Agent;
import io.jaegertracing.internal.exceptions.SenderException;
import io.jaegertracing.thrift.internal.reporters.protocols.ThriftUdpTransport;
import io.jaegertracing.thrift.internal.senders.ThriftSender;
import io.jaegertracing.thrift.internal.senders.ThriftSenderBase;
import io.jaegertracing.thriftjava.Batch;
import io.jaegertracing.thriftjava.Process;
import io.jaegertracing.thriftjava.Span;
import java.util.List;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class UdpSender
extends ThriftSender {
    public static final String DEFAULT_AGENT_UDP_HOST = "localhost";
    public static final int DEFAULT_AGENT_UDP_COMPACT_PORT = 6831;
    private final String host;
    private final int port;
    private volatile Agent.Client agentClient;
    private volatile ThriftUdpTransport udpTransport;

    public UdpSender() throws TTransportException {
        this(DEFAULT_AGENT_UDP_HOST, 6831, 0);
    }

    public UdpSender(String host, int port, int maxPacketSize) throws TTransportException {
        super(ThriftSenderBase.ProtocolType.Compact, maxPacketSize);
        if (host == null || host.length() == 0) {
            host = DEFAULT_AGENT_UDP_HOST;
        }
        if (port == 0) {
            port = 6831;
        }
        this.host = host;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Agent.Client getAgentClient() throws TTransportException {
        Agent.Client localRef = this.agentClient;
        if (localRef == null) {
            UdpSender udpSender = this;
            synchronized (udpSender) {
                localRef = this.agentClient;
                if (localRef == null) {
                    this.udpTransport = ThriftUdpTransport.newThriftUdpClient(this.host, this.port);
                    this.agentClient = localRef = new Agent.Client(this.protocolFactory.getProtocol((TTransport)this.udpTransport));
                }
            }
        }
        return localRef;
    }

    @Override
    public void send(Process process, List<Span> spans) throws SenderException {
        try {
            this.getAgentClient().emitBatch(new Batch(process, spans));
        }
        catch (Exception e) {
            throw new SenderException(String.format("Could not send %d spans", spans.size()), (Throwable)e, spans.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() throws SenderException {
        try {
            int n = super.close();
            return n;
        }
        finally {
            UdpSender udpSender = this;
            synchronized (udpSender) {
                if (this.udpTransport != null) {
                    this.udpTransport.close();
                }
            }
        }
    }

    @Override
    public String toString() {
        return "UdpSender(host=" + this.host + ", port=" + this.port + ")";
    }
}

