/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.jose.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.wildfly.security.jose.util.StringPropertyReplacer;

public class SystemPropertiesJsonParserFactory
extends MappingJsonFactory {
    private static final Properties properties = new SystemEnvProperties();

    protected JsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        JsonParser delegate = super._createParser(in, ctxt);
        return new SystemPropertiesAwareJsonParser(delegate);
    }

    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        JsonParser delegate = super._createParser(r, ctxt);
        return new SystemPropertiesAwareJsonParser(delegate);
    }

    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        JsonParser delegate = super._createParser(data, offset, len, ctxt, recyclable);
        return new SystemPropertiesAwareJsonParser(delegate);
    }

    protected JsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        JsonParser delegate = super._createParser(data, offset, len, ctxt);
        return new SystemPropertiesAwareJsonParser(delegate);
    }

    private static class SystemEnvProperties
    extends Properties {
        private final Map<String, String> overrides;

        public SystemEnvProperties(Map<String, String> overrides) {
            this.overrides = overrides;
        }

        public SystemEnvProperties() {
            this.overrides = Collections.EMPTY_MAP;
        }

        @Override
        public String getProperty(String key) {
            if (this.overrides.containsKey(key)) {
                return this.overrides.get(key);
            }
            if (key.startsWith("env.")) {
                return System.getenv().get(key.substring(4));
            }
            return System.getProperty(key);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            String value = this.getProperty(key);
            return value != null ? value : defaultValue;
        }
    }

    public static class SystemPropertiesAwareJsonParser
    extends JsonParserDelegate {
        public SystemPropertiesAwareJsonParser(JsonParser d) {
            super(d);
        }

        public String getText() throws IOException {
            String orig = super.getText();
            return StringPropertyReplacer.replaceProperties(orig, properties);
        }
    }
}

