/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.Value;

public interface ServiceController<S>
extends Value<S> {
    public ServiceController<?> getParent();

    public ServiceContainer getServiceContainer();

    public Mode getMode();

    public boolean compareAndSetMode(Mode var1, Mode var2);

    public void setMode(Mode var1);

    public State getState();

    @Deprecated
    public Substate getSubstate();

    @Override
    @Deprecated
    public S getValue() throws IllegalStateException;

    @Deprecated
    public S awaitValue() throws IllegalStateException, InterruptedException;

    @Deprecated
    public S awaitValue(long var1, TimeUnit var3) throws IllegalStateException, InterruptedException, TimeoutException;

    @Deprecated
    public Service<S> getService() throws IllegalStateException;

    public ServiceName getName();

    public ServiceName[] getAliases();

    public void addListener(LifecycleListener var1);

    @Deprecated
    public void addListener(ServiceListener<? super S> var1);

    public void removeListener(LifecycleListener var1);

    @Deprecated
    public void removeListener(ServiceListener<? super S> var1);

    public StartException getStartException();

    public void retry();

    @Deprecated
    public Set<ServiceName> getImmediateUnavailableDependencies();

    public Collection<ServiceName> getUnavailableDependencies();

    @Deprecated
    public static enum Transition {
        START_REQUESTED_to_DOWN(Substate.START_REQUESTED, Substate.DOWN),
        START_REQUESTED_to_PROBLEM(Substate.START_REQUESTED, Substate.PROBLEM),
        START_REQUESTED_to_START_INITIATING(Substate.START_REQUESTED, Substate.START_INITIATING),
        PROBLEM_to_START_REQUESTED(Substate.PROBLEM, Substate.START_REQUESTED),
        START_INITIATING_to_STARTING(Substate.START_INITIATING, Substate.STARTING),
        START_INITIATING_to_START_REQUESTED(Substate.START_INITIATING, Substate.START_REQUESTED),
        STARTING_to_UP(Substate.STARTING, Substate.UP),
        STARTING_to_START_FAILED(Substate.STARTING, Substate.START_FAILED),
        START_FAILED_to_STARTING(Substate.START_FAILED, Substate.START_INITIATING),
        START_FAILED_to_DOWN(Substate.START_FAILED, Substate.DOWN),
        UP_to_STOP_REQUESTED(Substate.UP, Substate.STOP_REQUESTED),
        STOP_REQUESTED_to_UP(Substate.STOP_REQUESTED, Substate.UP),
        STOP_REQUESTED_to_STOPPING(Substate.STOP_REQUESTED, Substate.STOPPING),
        STOPPING_to_DOWN(Substate.STOPPING, Substate.DOWN),
        REMOVING_to_REMOVED(Substate.REMOVING, Substate.REMOVED),
        REMOVED_to_TERMINATED(Substate.REMOVED, Substate.TERMINATED),
        REMOVING_to_DOWN(Substate.REMOVING, Substate.DOWN),
        DOWN_to_REMOVING(Substate.DOWN, Substate.REMOVING),
        DOWN_to_START_REQUESTED(Substate.DOWN, Substate.START_REQUESTED),
        DOWN_to_WAITING(Substate.DOWN, Substate.WAITING),
        DOWN_to_WONT_START(Substate.DOWN, Substate.WONT_START),
        WAITING_to_DOWN(Substate.WAITING, Substate.DOWN),
        WONT_START_to_DOWN(Substate.WONT_START, Substate.DOWN),
        CANCELLED_to_REMOVED(Substate.CANCELLED, Substate.REMOVED),
        NEW_to_DOWN(Substate.NEW, Substate.DOWN);

        private final Substate before;
        private final Substate after;

        private Transition(Substate before, Substate after) {
            this.before = before;
            this.after = after;
        }

        public boolean leavesRestState() {
            return this.before.isRestState() && !this.after.isRestState();
        }

        public boolean entersRestState() {
            return !this.before.isRestState() && this.after.isRestState();
        }

        public boolean enters(State state) {
            return this.before.getState() != state && this.after.getState() == state;
        }

        public boolean exits(State state) {
            return this.before.getState() == state && this.after.getState() != state;
        }

        public boolean retains(State state) {
            return this.before.getState() == state && this.after.getState() == state;
        }

        public Substate getBefore() {
            return this.before;
        }

        public Substate getAfter() {
            return this.after;
        }

        public boolean in(Transition ... transitions) {
            for (Transition test : transitions) {
                if (this != test) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "transition from " + this.before.name() + " to " + this.after.name();
        }
    }

    @Deprecated
    public static enum Substate {
        NEW(State.DOWN, true),
        CANCELLED(State.REMOVED, true),
        DOWN(State.DOWN, false),
        WAITING(State.DOWN, true),
        WONT_START(State.DOWN, true),
        PROBLEM(State.DOWN, true),
        START_REQUESTED(State.DOWN, false),
        START_INITIATING(State.STARTING, false),
        STARTING(State.STARTING, false),
        START_FAILED(State.START_FAILED, true),
        UP(State.UP, true),
        STOP_REQUESTED(State.UP, false),
        STOPPING(State.STOPPING, false),
        REMOVING(State.DOWN, false),
        REMOVED(State.REMOVED, false),
        TERMINATED(State.REMOVED, true);

        private final State state;
        private final boolean restState;

        private Substate(State state, boolean restState) {
            this.state = state;
            this.restState = restState;
        }

        public boolean isRestState() {
            return this.restState;
        }

        public State getState() {
            return this.state;
        }

        public boolean in(Substate ... substates) {
            for (Substate test : substates) {
                if (this != test) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Mode {
        REMOVE,
        NEVER,
        ON_DEMAND,
        LAZY,
        PASSIVE,
        ACTIVE;


        public boolean in(Mode ... modes) {
            for (Mode test : modes) {
                if (this != test) continue;
                return true;
            }
            return false;
        }
    }

    public static enum State {
        DOWN,
        STARTING,
        START_FAILED,
        UP,
        STOPPING,
        REMOVED;


        public boolean in(State ... states) {
            for (State test : states) {
                if (this != test) continue;
                return true;
            }
            return false;
        }
    }
}

