/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public final class ProtocolSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final String protocol;

    public ProtocolSaslClientFactory(SaslClientFactory delegate, String protocol) {
        super(delegate);
        this.protocol = protocol;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return super.createSaslClient(mechanisms, authorizationId, this.protocol, serverName, props, cbh);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ProtocolSaslClientFactory && this.equals((ProtocolSaslClientFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof ProtocolSaslClientFactory && this.equals((ProtocolSaslClientFactory)other);
    }

    public boolean equals(ProtocolSaslClientFactory other) {
        return super.equals(other) && this.protocol.equals(other.protocol);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(super.calculateHashCode(), this.getClass().hashCode()), this.protocol.hashCode());
    }
}

