/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.narayana;

import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.XAResourceWrapper;

public class RecoveryXAResource
implements AutoCloseable,
XAResourceWrapper {
    private static final String PRODUCT_NAME = RecoveryXAResource.class.getPackage().getImplementationTitle();
    private static final String PRODUCT_VERSION = RecoveryXAResource.class.getPackage().getImplementationVersion();
    private final XAResource wrappedResource;
    private final String jndiName;
    private XAConnection xaConnection;

    public RecoveryXAResource(XAConnection connection, String name) throws SQLException {
        this.xaConnection = connection;
        this.wrappedResource = connection.getXAResource();
        this.jndiName = name;
    }

    public Xid[] recover(int flag) throws XAException {
        if (this.xaConnection == null) {
            throw new XAException(-7);
        }
        Xid[] value = this.wrappedResource.recover(flag);
        if (flag == 0x800000 && (value == null || value.length == 0)) {
            this.close();
        }
        return value;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.wrappedResource.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.wrappedResource.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        this.wrappedResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.wrappedResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return this.wrappedResource.isSameRM(xares);
    }

    public int prepare(Xid xid) throws XAException {
        return this.wrappedResource.prepare(xid);
    }

    public void rollback(Xid xid) throws XAException {
        this.wrappedResource.rollback(xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.wrappedResource.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.wrappedResource.start(xid, flags);
    }

    @Override
    public void close() throws XAException {
        try {
            this.xaConnection.close();
        }
        catch (SQLException e) {
            XAException xaException = new XAException(-7);
            xaException.initCause(e);
            throw xaException;
        }
        finally {
            this.xaConnection = null;
        }
    }

    public XAResource getResource() {
        return this.wrappedResource;
    }

    public String getProductName() {
        return PRODUCT_NAME;
    }

    public String getProductVersion() {
        return PRODUCT_VERSION;
    }

    public String getJndiName() {
        return this.jndiName;
    }
}

