/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.secured;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.secured.FileTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.secured.HttpAccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.secured.JaasOptionsUtils;

public class AccessTokenRetrieverFactory {
    public static AccessTokenRetriever create(Map<String, ?> configs, Map<String, Object> jaasConfig) {
        return AccessTokenRetrieverFactory.create(configs, null, jaasConfig);
    }

    public static AccessTokenRetriever create(Map<String, ?> configs, String saslMechanism, Map<String, Object> jaasConfig) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        URL tokenEndpointUrl = cu.validateUrl("sasl.oauthbearer.token.endpoint.url");
        if (tokenEndpointUrl.getProtocol().toLowerCase(Locale.ROOT).equals("file")) {
            return new FileTokenRetriever(cu.validateFile("sasl.oauthbearer.token.endpoint.url"));
        }
        JaasOptionsUtils jou = new JaasOptionsUtils(jaasConfig);
        String clientId = jou.validateString("clientId");
        String clientSecret = jou.validateString("clientSecret");
        String scope = jou.validateString("scope", false);
        SSLSocketFactory sslSocketFactory = null;
        if (jou.shouldCreateSSLSocketFactory(tokenEndpointUrl)) {
            sslSocketFactory = jou.createSSLSocketFactory();
        }
        return new HttpAccessTokenRetriever(clientId, clientSecret, scope, sslSocketFactory, tokenEndpointUrl.toString(), cu.validateLong("sasl.login.retry.backoff.ms"), cu.validateLong("sasl.login.retry.backoff.max.ms"), cu.validateInteger("sasl.login.connect.timeout.ms", false), cu.validateInteger("sasl.login.read.timeout.ms", false));
    }
}

