/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.DeserializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSource;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;

public class DeserializerWrapper<T>
implements Deserializer<T> {
    private final Deserializer<T> delegate;
    private final boolean handleKeys;
    private final DeserializationFailureHandler<T> deserializationFailureHandler;
    private final KafkaSource<?, ?> source;
    private final boolean failOnDeserializationErrorWithoutHandler;

    public DeserializerWrapper(String className, boolean key, DeserializationFailureHandler<T> failureHandler, KafkaSource<?, ?> source, boolean failByDefault) {
        this.delegate = this.createDelegateDeserializer(className);
        this.handleKeys = key;
        this.deserializationFailureHandler = failureHandler;
        this.source = source;
        this.failOnDeserializationErrorWithoutHandler = failByDefault;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            this.delegate.configure(configs, isKey);
        }
        catch (Exception e) {
            this.source.reportFailure(e, true);
            throw new KafkaException((Throwable)e);
        }
    }

    private Deserializer<T> createDelegateDeserializer(String clazz) {
        try {
            return (Deserializer)Utils.newInstance((String)clazz, Deserializer.class);
        }
        catch (ClassNotFoundException e) {
            throw KafkaExceptions.ex.unableToCreateInstance(clazz, e);
        }
    }

    public T deserialize(String topic, byte[] data) {
        return (T)this.wrapDeserialize(() -> this.delegate.deserialize(topic, data), topic, null, data);
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        return (T)this.wrapDeserialize(() -> this.delegate.deserialize(topic, headers, data), topic, headers, data);
    }

    private T wrapDeserialize(Supplier<T> deserialize, String topic, Headers headers, byte[] data) {
        if (this.deserializationFailureHandler != null) {
            try {
                return this.deserializationFailureHandler.decorateDeserialization(Uni.createFrom().item(deserialize), topic, this.handleKeys, this.delegate.getClass().getName(), data, headers);
            }
            catch (Exception e) {
                KafkaLogging.log.deserializationFailureHandlerFailure(this.deserializationFailureHandler.toString(), e);
                this.source.reportFailure(e, true);
                if (e instanceof KafkaException) {
                    throw (KafkaException)e;
                }
                throw new KafkaException((Throwable)e);
            }
        }
        try {
            return deserialize.get();
        }
        catch (Exception e) {
            if (this.failOnDeserializationErrorWithoutHandler) {
                this.source.reportFailure(e, true);
                if (e instanceof KafkaException) {
                    throw (KafkaException)e;
                }
                throw new KafkaException((Throwable)e);
            }
            return null;
        }
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

