/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jaspi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.message.config.AuthConfigFactory;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    private static final PrivilegedAction<AuthConfigFactory> GET_AUTH_CONFIG_FACTORY_ACTION = new PrivilegedAction<AuthConfigFactory>(){

        @Override
        public AuthConfigFactory run() {
            return AuthConfigFactory.getFactory();
        }
    };

    SecurityActions() {
    }

    static AuthConfigFactory getAuthConfigFactory() {
        return WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(GET_AUTH_CONFIG_FACTORY_ACTION) : GET_AUTH_CONFIG_FACTORY_ACTION.run();
    }

    public static SecurityContext getSecurityContext() {
        if (WildFlySecurityManager.isChecking()) {
            return (SecurityContext)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<SecurityContext>(){

                @Override
                public SecurityContext run() {
                    return SecurityContextAssociation.getSecurityContext();
                }
            });
        }
        return SecurityContextAssociation.getSecurityContext();
    }
}

