/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.infinispan.session.AbstractInfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaDataFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;

public class InfinispanSessionMetaDataFactory<L>
extends AbstractInfinispanSessionMetaDataFactory<L> {
    private final Cache<Key<String>, Object> cache;

    public InfinispanSessionMetaDataFactory(InfinispanSessionMetaDataFactoryConfiguration configuration) {
        super(configuration);
        this.cache = configuration.getCache();
    }

    @Override
    public CompositeSessionMetaDataEntry<L> apply(String id, Set<Flag> flags) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        HashSet<GroupedKey> keys = new HashSet<GroupedKey>(3);
        keys.add(creationMetaDataKey);
        keys.add(accessMetaDataKey);
        Map entries = this.cache.getAdvancedCache().withFlags(flags).getAll(keys);
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)entries.get((Object)creationMetaDataKey);
        SessionAccessMetaData accessMetaData = (SessionAccessMetaData)entries.get((Object)accessMetaDataKey);
        if (creationMetaDataEntry != null && accessMetaData != null) {
            return new CompositeSessionMetaDataEntry(creationMetaDataEntry, accessMetaData);
        }
        if (flags.isEmpty() && (creationMetaDataEntry != null || accessMetaData != null)) {
            this.purge(id);
        }
        return null;
    }
}

