/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.calendar.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.calendar.control.CalendarException;
import com.stratelia.webactiv.calendar.model.JournalHeader;
import com.stratelia.webactiv.calendar.model.SchedulableCount;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class JournalDAO {
    public static final String COLUMNNAMES = "id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId";
    private static final String JOURNALCOLUMNNAMES = "CalendarJournal.id, CalendarJournal.name, CalendarJournal.delegatorId, CalendarJournal.description, CalendarJournal.priority,  CalendarJournal.classification, CalendarJournal.startDay, CalendarJournal.startHour, CalendarJournal.endDay, CalendarJournal.endHour, CalendarJournal.externalId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addJournal(Connection con, JournalHeader journal) throws SQLException, UtilException, CalendarException {
        int id;
        String insertStatement = "insert into CalendarJournal (id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId)  values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertStatement);
            id = DBUtil.getNextId((Connection)con, (String)"CalendarJournal", (String)"id");
            prepStmt.setInt(1, id);
            prepStmt.setString(2, journal.getName());
            prepStmt.setString(3, journal.getDelegatorId());
            prepStmt.setString(4, journal.getDescription());
            prepStmt.setInt(5, journal.getPriority().getValue());
            prepStmt.setString(6, journal.getClassification().getString());
            prepStmt.setString(7, journal.getStartDay());
            prepStmt.setString(8, journal.getStartHour());
            prepStmt.setString(9, journal.getEndDay());
            prepStmt.setString(10, journal.getEndHour());
            prepStmt.setString(11, journal.getExternalId());
            if (prepStmt.executeUpdate() == 0) {
                throw new CalendarException("JournalDAO.Connection con,  addJournal(Connection con, JournalHeader journal)", 4, "calendar.EX_EXCUTE_INSERT_EMPTY");
            }
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return String.valueOf(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateJournal(Connection con, JournalHeader journal) throws SQLException, CalendarException {
        PreparedStatement prepStmt = null;
        try {
            String insertStatement = "update CalendarJournal  set name = ?, delegatorId = ?, description = ?, priority = ?, classification = ?, startDay = ?, startHour = ?, endDay = ?, endHour = ?, externalId = ? where id = ?";
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setString(1, journal.getName());
            prepStmt.setString(2, journal.getDelegatorId());
            prepStmt.setString(3, journal.getDescription());
            prepStmt.setInt(4, journal.getPriority().getValue());
            prepStmt.setString(5, journal.getClassification().getString());
            prepStmt.setString(6, journal.getStartDay());
            prepStmt.setString(7, journal.getStartHour());
            prepStmt.setString(8, journal.getEndDay());
            prepStmt.setString(9, journal.getEndHour());
            prepStmt.setString(10, journal.getExternalId());
            prepStmt.setInt(11, new Integer(journal.getId()));
            if (prepStmt.executeUpdate() == 0) {
                throw new CalendarException("JournalDAO.Connection con,  addJournal(Connection con, JournalHeader journal)", 4, "calendar.EX_EXCUTE_UPDATE_EMPTY");
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJournal(Connection con, String id) throws SQLException, CalendarException {
        PreparedStatement prepStmt = null;
        try {
            String statement = "delete from CalendarJournal where id = ?";
            prepStmt = con.prepareStatement(statement);
            prepStmt.setInt(1, new Integer(id));
            if (prepStmt.executeUpdate() == 0) {
                throw new CalendarException("JournalDAO.Connection con,  addJournal(Connection con, JournalHeader journal)", 4, "calendar.EX_EXCUTE_DELETE_EMPTY");
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTentativeJournalsForUser(Connection con, String userId) throws SQLException, ParseException {
        boolean r;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = JournalDAO.getTentativePreparedStatement(con, userId);
            rs = prepStmt.executeQuery();
            r = rs.next();
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getTentativeJournalHeadersForUser(Connection con, String userId) throws SQLException, ParseException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<JournalHeader> list = null;
        try {
            prepStmt = JournalDAO.getTentativePreparedStatement(con, userId);
            rs = prepStmt.executeQuery();
            list = new ArrayList<JournalHeader>();
            while (rs.next()) {
                JournalHeader journal = JournalDAO.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return list;
    }

    private static PreparedStatement getTentativePreparedStatement(Connection con, String userId) throws SQLException {
        String selectStatement = "select distinct CalendarJournal.id, CalendarJournal.name, CalendarJournal.delegatorId, CalendarJournal.description, CalendarJournal.priority,  CalendarJournal.classification, CalendarJournal.startDay, CalendarJournal.startHour, CalendarJournal.endDay, CalendarJournal.endHour, CalendarJournal.externalId from CalendarJournal, CalendarJournalAttendee  WHERE (CalendarJournal.id = CalendarJournalAttendee.journalId)  and (CalendarJournalAttendee.participationStatus = ?)  and (userId = ?)  order by startDay, startHour";
        PreparedStatement prepStmt = con.prepareStatement(selectStatement);
        prepStmt.setString(1, "tentative");
        prepStmt.setString(2, userId);
        return prepStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection getJournalHeadersForUser(Connection con, String day, String userId, String categoryId, String participation, String comparator) throws SQLException, ParseException {
        StringBuffer selectStatement = new StringBuffer();
        selectStatement.append("select distinct ").append(JOURNALCOLUMNNAMES).append(" from CalendarJournal, CalendarJournalAttendee ");
        if (categoryId != null) {
            selectStatement.append(", CalendarJournalCategory ");
        }
        selectStatement.append(" where (CalendarJournal.id = CalendarJournalAttendee.journalId) ");
        selectStatement.append(" and (userId = '").append(userId).append("'");
        selectStatement.append(" and participationStatus = '").append(participation).append("') ");
        if (categoryId != null) {
            selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId) ");
            selectStatement.append(" and (CalendarJournalCategory.categoryId = '").append(categoryId).append("') ");
        }
        selectStatement.append(" and ((startDay ").append(comparator).append(" '").append(day).append("') or (startDay <= '").append(day).append("' and endDay >= '").append(day).append("')) ");
        if (participation.equals("accepted")) {
            selectStatement.append("union ").append("select distinct ").append(JOURNALCOLUMNNAMES).append(" from CalendarJournal ");
            if (categoryId != null) {
                selectStatement.append(", CalendarJournalCategory ");
            }
            selectStatement.append(" where (delegatorId = '").append(userId).append("') ");
            if (categoryId != null) {
                selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId) ");
                selectStatement.append(" and (CalendarJournalCategory.categoryId = '").append(categoryId).append("') ");
            }
            selectStatement.append(" and ((startDay ").append(comparator).append(" '").append(day).append("') or (startDay <= '").append(day).append("' and endDay >= '").append(day).append("')) ");
        }
        selectStatement.append(" order by 7 , 8 ");
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<JournalHeader> list = null;
        try {
            prepStmt = con.prepareStatement(selectStatement.toString());
            rs = prepStmt.executeQuery();
            list = new ArrayList<JournalHeader>();
            while (rs.next()) {
                JournalHeader journal = JournalDAO.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return list;
    }

    public static Collection getDayJournalHeadersForUser(Connection con, String day, String userId, String categoryId, String participation) throws SQLException, ParseException {
        return JournalDAO.getJournalHeadersForUser(con, day, userId, categoryId, participation, "=");
    }

    public static Collection getNextJournalHeadersForUser(Connection con, String day, String userId, String categoryId, String participation) throws SQLException, ParseException {
        return JournalDAO.getJournalHeadersForUser(con, day, userId, categoryId, participation, ">=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection countMonthJournalsForUser(Connection con, String month, String userId, String categoryId, String participation) throws SQLException {
        StringBuffer selectStatement = new StringBuffer(200);
        String theDay = "";
        selectStatement.append("select count(distinct CalendarJournal.id), ? from CalendarJournal, CalendarJournalAttendee ");
        if (categoryId != null) {
            selectStatement.append(", CalendarJournalCategory ");
        }
        selectStatement.append("where (CalendarJournal.id = CalendarJournalAttendee.journalId) ");
        selectStatement.append("and (userId = ").append(userId);
        selectStatement.append(" and participationStatus = '").append(participation).append("')");
        selectStatement.append(" and ((startDay = ?) or ((startDay <= ?) and (endDay >= ?))) ");
        if (categoryId != null) {
            selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId)");
            selectStatement.append(" and (CalendarJournalCategory.categoryId = '").append(categoryId).append("') ");
        }
        selectStatement.append("group by ?");
        if (participation.equals("accepted")) {
            selectStatement.append("union select count(distinct CalendarJournal.id), ? from CalendarJournal ");
            if (categoryId != null) {
                selectStatement.append(", CalendarJournalCategory ");
            }
            selectStatement.append("where (delegatorId = '").append(userId).append("')");
            selectStatement.append(" and ((startDay = ?) or ((startDay <= ?) and (endDay >= ?)))");
            if (categoryId != null) {
                selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId)");
                selectStatement.append(" and (CalendarJournalCategory.categoryId = '").append(categoryId).append("') ");
            }
            selectStatement.append("group by ?");
        }
        ArrayList<SchedulableCount> list = new ArrayList<SchedulableCount>();
        String date = "";
        PreparedStatement prepStmt = null;
        try {
            ResultSet rs = null;
            prepStmt = con.prepareStatement(selectStatement.toString());
            for (int day = 1; day == 31; ++day) {
                theDay = day < 10 ? month + "0" + String.valueOf(day) : month + String.valueOf(day);
                prepStmt.setString(1, theDay);
                prepStmt.setString(2, theDay);
                prepStmt.setString(3, theDay);
                prepStmt.setString(4, theDay);
                prepStmt.setString(5, theDay);
                prepStmt.setString(6, theDay);
                prepStmt.setString(7, theDay);
                prepStmt.setString(8, theDay);
                prepStmt.setString(9, theDay);
                prepStmt.setString(10, theDay);
                rs = prepStmt.executeQuery();
                while (rs.next()) {
                    int number = rs.getInt(1);
                    date = rs.getString(2);
                    SchedulableCount count = new SchedulableCount(number, date);
                    list.add(count);
                }
                DBUtil.close((ResultSet)rs);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getPeriodJournalHeadersForUser(Connection con, String begin, String end, String userId, String categoryId, String participation) throws SQLException, ParseException {
        StringBuffer selectStatement = new StringBuffer(200);
        selectStatement.append("select distinct ").append(COLUMNNAMES).append(" from CalendarJournal, CalendarJournalAttendee ");
        if (categoryId != null) {
            selectStatement.append(", CalendarJournalCategory ");
        }
        selectStatement.append(" where (CalendarJournal.id = CalendarJournalAttendee.journalId) ");
        selectStatement.append(" and (userId = '").append(userId).append("' ");
        selectStatement.append(" and participationStatus = '").append(participation).append("') ");
        if (categoryId != null) {
            selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId) ");
            selectStatement.append(" and (categoryId = '").append(categoryId).append("') ");
        }
        selectStatement.append(" and ( (startDay >= '").append(begin).append("' and startDay <= '").append(end).append("')");
        selectStatement.append(" or (endDay >= '").append(begin).append("' and endDay <= '").append(end).append("')");
        selectStatement.append(" or ('").append(begin).append("' >= startDay and '").append(begin).append("' <= endDay) ");
        selectStatement.append(" or ('").append(end).append("' >= startDay and '").append(end).append("' <= endDay) ) ");
        if (participation.equals("accepted")) {
            selectStatement.append(" union select distinct ").append(COLUMNNAMES).append(" from CalendarJournal ");
            if (categoryId != null) {
                selectStatement.append(", CalendarJournalCategory ");
            }
            selectStatement.append("where (delegatorId = '").append(userId).append("') ");
            if (categoryId != null) {
                selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId) ");
                selectStatement.append(" and (categoryId = '").append(categoryId).append("') ");
            }
            selectStatement.append(" and ( (startDay >= '").append(begin).append("' and startDay <= '").append(end).append("')");
            selectStatement.append(" or (endDay >= '").append(begin).append("' and endDay <= '").append(end).append("')");
            selectStatement.append(" or ('").append(begin).append("' >= startDay and '").append(begin).append("' <= endDay) ");
            selectStatement.append(" or ('").append(end).append("' >= startDay and '").append(end).append("' <= endDay) ) ");
        }
        selectStatement.append(" order by 7 , 8 ");
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<JournalHeader> list = null;
        try {
            prepStmt = con.prepareStatement(selectStatement.toString());
            rs = prepStmt.executeQuery();
            list = new ArrayList<JournalHeader>();
            while (rs.next()) {
                JournalHeader journal = JournalDAO.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return list;
    }

    public static JournalHeader getJournalHeaderFromResultSet(ResultSet rs) throws SQLException, ParseException {
        String id = "" + rs.getInt(1);
        String name = rs.getString(2);
        String delegatorId = rs.getString(3);
        JournalHeader journal = new JournalHeader(id, name, delegatorId);
        journal.setDescription(rs.getString(4));
        try {
            journal.getPriority().setValue(rs.getInt(5));
        }
        catch (Exception e) {
            SilverTrace.warn((String)"calendar", (String)"JournalDAO.getJournalHeaderFromResultSet(ResultSet rs)", (String)"calendar_MSG_NOT_GET_PRIORITY");
        }
        journal.getClassification().setString(rs.getString(6));
        journal.setStartDay(rs.getString(7));
        journal.setStartHour(rs.getString(8));
        journal.setEndDay(rs.getString(9));
        journal.setEndHour(rs.getString(10));
        journal.setExternalId(rs.getString(11));
        return journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JournalHeader getJournalHeader(Connection con, String journalId) throws SQLException, CalendarException, ParseException {
        JournalHeader journalHeader;
        String selectStatement = "select id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId from CalendarJournal where id = ?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setInt(1, new Integer(journalId));
            rs = prepStmt.executeQuery();
            if (!rs.next()) {
                throw new CalendarException("JournalDAO.Connection con, String journalId", 4, "calendar.EX_RS_EMPTY", "journalId=" + journalId);
            }
            JournalHeader journal = JournalDAO.getJournalHeaderFromResultSet(rs);
            journalHeader = journal;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return journalHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getOutlookJournalHeadersForUser(Connection con, String userId) throws SQLException, CalendarException, ParseException {
        ArrayList<JournalHeader> arrayList;
        String selectStatement = "select id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId from CalendarJournal where delegatorId = ? and externalId is not null";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<JournalHeader> list = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setString(1, userId);
            rs = prepStmt.executeQuery();
            list = new ArrayList<JournalHeader>();
            while (rs.next()) {
                JournalHeader journal = JournalDAO.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getOutlookJournalHeadersForUserAfterDate(Connection con, String userId, Date startDate) throws SQLException, CalendarException, ParseException {
        ArrayList<JournalHeader> arrayList;
        String selectStatement = "select id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId from CalendarJournal where delegatorId = ? and startDay >= ? and externalId is not null";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        ArrayList<JournalHeader> list = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setString(1, userId);
            prepStmt.setString(2, format.format(startDate));
            rs = prepStmt.executeQuery();
            list = new ArrayList<JournalHeader>();
            while (rs.next()) {
                JournalHeader journal = JournalDAO.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getJournalHeadersForUserAfterDate(Connection con, String userId, Date startDate, int nbReturned) throws SQLException, CalendarException, ParseException {
        ArrayList<JournalHeader> arrayList;
        String selectStatement = "select id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId from CalendarJournal where delegatorId = ? and ((startDay >= ?) or (startDay <= ? and endDay >= ?)) order by 7, 8";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        String startDateString = format.format(startDate);
        ArrayList<JournalHeader> list = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setString(1, userId);
            prepStmt.setString(2, startDateString);
            prepStmt.setString(3, startDateString);
            prepStmt.setString(4, startDateString);
            rs = prepStmt.executeQuery();
            list = new ArrayList<JournalHeader>();
            while (rs.next() && nbReturned != 0) {
                JournalHeader journal = JournalDAO.getJournalHeaderFromResultSet(rs);
                list.add(journal);
                --nbReturned;
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }
}

