/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.container.service;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.questioncontainer.answer.model.AnswerPK;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerDetail;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerPK;
import org.silverpeas.core.questioncontainer.question.model.Question;
import org.silverpeas.core.questioncontainer.question.model.QuestionPK;
import org.silverpeas.core.questioncontainer.result.model.QuestionResult;
import org.silverpeas.core.questioncontainer.score.model.ScoreDetail;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.csv.CSVRow;

public interface QuestionContainerService {
    public static QuestionContainerService get() {
        return (QuestionContainerService)ServiceProvider.getService(QuestionContainerService.class, (Annotation[])new Annotation[0]);
    }

    public void recordReplyToQuestionContainerByUser(QuestionContainerPK var1, String var2, Map<String, List<String>> var3);

    public void recordReplyToQuestionContainerByUser(QuestionContainerPK var1, String var2, Map<String, List<String>> var3, String var4, boolean var5);

    public Collection<QuestionResult> getSuggestions(QuestionContainerPK var1);

    public QuestionResult getSuggestion(String var1, QuestionPK var2, AnswerPK var3);

    public Collection<QuestionContainerHeader> getQuestionContainerHeaders(List<QuestionContainerPK> var1);

    public QuestionContainerDetail getQuestionContainer(QuestionContainerPK var1, String var2);

    public QuestionContainerDetail getQuestionContainerByParticipationId(QuestionContainerPK var1, String var2, int var3);

    public Collection<QuestionContainerHeader> getNotClosedQuestionContainers(QuestionContainerPK var1);

    public Collection<QuestionContainerHeader> getOpenedQuestionContainers(QuestionContainerPK var1);

    public Collection<QuestionContainerHeader> getClosedQuestionContainers(QuestionContainerPK var1);

    public Collection<QuestionContainerHeader> getInWaitQuestionContainers(QuestionContainerPK var1);

    public void closeQuestionContainer(QuestionContainerPK var1);

    public void openQuestionContainer(QuestionContainerPK var1);

    public int getNbVotersByQuestionContainer(QuestionContainerPK var1);

    public QuestionContainerPK createQuestionContainer(QuestionContainerPK var1, QuestionContainerDetail var2, String var3);

    public void deleteQuestionContainer(QuestionContainerPK var1);

    public void deleteVotes(QuestionContainerPK var1);

    public void updateQuestionContainerHeader(QuestionContainerHeader var1);

    public void updateQuestions(QuestionContainerPK var1, Collection<Question> var2);

    public float getAveragePoints(QuestionContainerPK var1);

    public Collection<QuestionContainerHeader> getOpenedQuestionContainersAndUserScores(QuestionContainerPK var1, String var2);

    public Collection<QuestionContainerHeader> getQuestionContainersWithScores(QuestionContainerPK var1);

    public Collection<QuestionContainerHeader> getQuestionContainersWithUserScores(QuestionContainerPK var1, String var2);

    public Collection<ScoreDetail> getUserScoresByFatherId(QuestionContainerPK var1, String var2);

    public Collection<ScoreDetail> getBestScoresByFatherId(QuestionContainerPK var1, int var2);

    public float getAverageScoreByFatherId(QuestionContainerPK var1);

    public Collection<ScoreDetail> getScoresByFatherId(QuestionContainerPK var1);

    public int getUserNbParticipationsByFatherId(QuestionContainerPK var1, String var2);

    public ScoreDetail getUserScoreByFatherIdAndParticipationId(QuestionContainerPK var1, String var2, int var3);

    public void updateScore(QuestionContainerPK var1, ScoreDetail var2);

    public void deleteIndex(QuestionContainerPK var1);

    public int getSilverObjectId(QuestionContainerPK var1);

    public String getHTMLQuestionPath(QuestionContainerDetail var1);

    public QuestionContainerHeader getQuestionContainerHeader(QuestionContainerPK var1);

    public List<CSVRow> exportCSV(QuestionContainerDetail var1, boolean var2);

    public Collection<ScoreDetail> getWorstScoresByFatherId(QuestionContainerPK var1, int var2);
}

